/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.action.types;

import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.core.teleportation.PassengerMode;
import org.mvplugins.multiverse.core.teleportation.PassengerModes;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.action.ActionFailureReason;
import org.mvplugins.multiverse.portals.action.ActionHandler;
import org.mvplugins.multiverse.portals.action.types.MultiverseDestinationActionHandlerType;
import org.mvplugins.multiverse.portals.util.MVPLogging;

final class MultiverseDestinationActionHandler
extends ActionHandler<MultiverseDestinationActionHandlerType, MultiverseDestinationActionHandler> {
    private final AsyncSafetyTeleporter teleporter;
    private final DestinationInstance<?, ?> destinationInstance;

    MultiverseDestinationActionHandler(MultiverseDestinationActionHandlerType handlerType, AsyncSafetyTeleporter teleporter, DestinationInstance<?, ?> destinationInstance) {
        super(handlerType);
        this.teleporter = teleporter;
        this.destinationInstance = destinationInstance;
    }

    @Override
    @NotNull
    public Attempt<Void, ActionFailureReason> runAction(@NotNull MVPortal portal, @NotNull Entity entity) {
        this.teleporter.to(this.destinationInstance).checkSafety(portal.getCheckDestinationSafety() && this.destinationInstance.checkTeleportSafety()).passengerMode(this.passengerModeFor(portal, entity)).teleportSingle(entity).onFailure(reason -> MVPLogging.warning("Failed to teleport entity '%s' to destination '%s'. Reason: %s", entity.getName(), this.destinationInstance, reason));
        return Attempt.success(null);
    }

    @Override
    @NotNull
    public Message actionDescription(Entity entity) {
        return Message.of((String)(String.valueOf(ChatColor.AQUA) + "Teleports to " + String.valueOf(ChatColor.GOLD) + this.destinationInstance.toString()), (MessageReplacement[])new MessageReplacement[0]);
    }

    private PassengerMode passengerModeFor(MVPortal portal, Entity entity) {
        if (entity instanceof Vehicle) {
            return PassengerModes.RETAIN_ALL;
        }
        return portal.getTeleportNonPlayers() ? PassengerModes.RETAIN_ALL : PassengerModes.DISMOUNT_VEHICLE;
    }

    @Override
    @NotNull
    public String serialise() {
        return this.destinationInstance.toString();
    }
}

