/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.action.types;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.event.MVConfigReloadEvent;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.util.MVPLogging;

@Service
final class BungeeServerList
implements Listener,
PluginMessageListener {
    @NotNull
    private final MultiversePortals plugin;
    private boolean didFirstRun = false;
    private List<String> serverNames;

    @Inject
    BungeeServerList(@NotNull MultiversePortals plugin) {
        this.plugin = plugin;
        this.serverNames = Collections.emptyList();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        Bukkit.getMessenger().registerIncomingPluginChannel((Plugin)plugin, "BungeeCord", (PluginMessageListener)this);
    }

    Collection<String> getServerNames() {
        return this.serverNames;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        if (!channel.equals("BungeeCord")) {
            return;
        }
        ByteArrayDataInput in = ByteStreams.newDataInput((byte[])message);
        String subchannel = in.readUTF();
        if (subchannel.equals("GetServers")) {
            this.serverNames = List.of(in.readUTF().split(", "));
            MVPLogging.fine("BungeeCord GetServers: " + String.join((CharSequence)", ", this.serverNames), new Object[0]);
        }
    }

    @EventHandler
    void playerJoin(PlayerJoinEvent event) {
        if (this.didFirstRun) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::callBungeeCordGetServers, 10L);
        this.didFirstRun = true;
    }

    @EventHandler
    void configReload(MVConfigReloadEvent event) {
        this.callBungeeCordGetServers();
    }

    private void callBungeeCordGetServers() {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("GetServers");
        Bukkit.getServer().sendPluginMessage((Plugin)this.plugin, "BungeeCord", out.toByteArray());
        MVPLogging.fine("Calling BungeeCord GetServers", new Object[0]);
    }
}

