/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.result.FailureReason;
import org.mvplugins.multiverse.external.jetbrains.annotations.ApiStatus;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.portals.action.ActionFailureReason;
import org.mvplugins.multiverse.portals.action.ActionHandler;
import org.mvplugins.multiverse.portals.action.ActionHandlerType;

@Service
@ApiStatus.AvailableSince(value="5.2")
public final class ActionHandlerProvider {
    private final Map<String, ActionHandlerType<?, ?>> handlerTypeMap = new HashMap();

    @ApiStatus.AvailableSince(value="5.2")
    public void registerHandlerType(@NotNull ActionHandlerType<?, ?> handlerType) {
        this.handlerTypeMap.put(handlerType.getName(), handlerType);
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public Collection<String> getAllHandlerTypeNames() {
        return this.handlerTypeMap.keySet();
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public Attempt<? extends ActionHandlerType<?, ?>, ActionFailureReason> getHandlerType(@NotNull String name) {
        return (Attempt)Option.of(this.handlerTypeMap.get(name)).map(Attempt::success).getOrElse(() -> Attempt.failure((FailureReason)ActionFailureReason.INSTANCE, (Message)Message.of((String)("Unknown action type '" + name + "'. Supported types are: " + String.join((CharSequence)", ", this.handlerTypeMap.keySet())), (MessageReplacement[])new MessageReplacement[0])));
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public Attempt<? extends ActionHandler<?, ?>, ActionFailureReason> parseHandler(@NotNull String actionType, @NotNull String action) {
        return this.parseHandler((CommandSender)Bukkit.getConsoleSender(), actionType, action);
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public Attempt<? extends ActionHandler<?, ?>, ActionFailureReason> parseHandler(@NotNull CommandSender sender, @NotNull String actionType, @NotNull String action) {
        return this.getHandlerType(actionType).mapAttempt(actionHandlerType -> actionHandlerType.parseHandler(sender, action));
    }
}

