/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals;

import java.lang.annotation.Annotation;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.core.inject.PluginServiceLocator;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.utils.PortalFiller;
import org.mvplugins.multiverse.portals.utils.PortalManager;

public final class MultiversePortalsApi {
    private static MultiversePortalsApi instance;
    private final PluginServiceLocator serviceLocator;

    static void init(@NotNull MultiversePortals multiversePortals) {
        if (instance != null) {
            throw new IllegalStateException("MultiversePortalsApi has already been initialized!");
        }
        instance = new MultiversePortalsApi(multiversePortals.getServiceLocator());
        Bukkit.getServicesManager().register(MultiversePortalsApi.class, (Object)instance, (Plugin)multiversePortals, ServicePriority.Normal);
    }

    static void shutdown() {
        Bukkit.getServicesManager().unregister((Object)instance);
        instance = null;
    }

    @NotNull
    public static MultiversePortalsApi get() {
        if (instance == null) {
            throw new IllegalStateException("MultiversePortalsApi has not been initialized!");
        }
        return instance;
    }

    private MultiversePortalsApi(@NotNull PluginServiceLocator serviceProvider) {
        this.serviceLocator = serviceProvider;
    }

    @NotNull
    public PortalFiller getPortalFiller() {
        return Objects.requireNonNull((PortalFiller)this.serviceLocator.getService(PortalFiller.class, new Annotation[0]));
    }

    @NotNull
    public PortalManager getPortalManager() {
        return Objects.requireNonNull((PortalManager)this.serviceLocator.getService(PortalManager.class, new Annotation[0]));
    }

    @ApiStatus.AvailableSince(value="5.1")
    @NotNull
    public PortalsConfig getPortalsConfig() {
        return Objects.requireNonNull((PortalsConfig)this.serviceLocator.getService(PortalsConfig.class, new Annotation[0]));
    }

    @NotNull
    public PluginServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }
}

