/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.jetbrains.annotations.ApiStatus;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.module.MultiverseModule;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jakarta.inject.Provider;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.portals.BstatsMetricsConfigurator;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortalsApi;
import org.mvplugins.multiverse.portals.MultiversePortalsPluginBinder;
import org.mvplugins.multiverse.portals.PortalPlayerSession;
import org.mvplugins.multiverse.portals.WorldEditConnection;
import org.mvplugins.multiverse.portals.action.ActionHandlerProvider;
import org.mvplugins.multiverse.portals.action.ActionHandlerType;
import org.mvplugins.multiverse.portals.command.PortalsCommandCompletions;
import org.mvplugins.multiverse.portals.command.PortalsCommandContexts;
import org.mvplugins.multiverse.portals.commands.PortalsCommand;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.destination.PortalDestination;
import org.mvplugins.multiverse.portals.destination.RandomPortalDestination;
import org.mvplugins.multiverse.portals.listeners.MVPEntityMoveListener;
import org.mvplugins.multiverse.portals.listeners.MVPEntityPortalListener;
import org.mvplugins.multiverse.portals.listeners.MVPPlayerMoveListener;
import org.mvplugins.multiverse.portals.listeners.MVPVehicleListener;
import org.mvplugins.multiverse.portals.listeners.PortalsListener;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
public class MultiversePortals
extends MultiverseModule {
    private static final double TARGET_CORE_API_VERSION = 5.1;
    @Inject
    private Provider<PortalManager> portalManager;
    @Inject
    private Provider<DestinationsProvider> destinationsProvider;
    @Inject
    private Provider<MVCommandManager> commandManager;
    @Inject
    private Provider<PortalsCommandCompletions> portalsCommandCompletions;
    @Inject
    private Provider<PortalsCommandContexts> portalsCommandContexts;
    @Inject
    private Provider<CoreConfig> coreConfig;
    @Inject
    private Provider<PortalsConfig> portalsConfigProvider;
    @Inject
    private Provider<BstatsMetricsConfigurator> metricsConfiguratorProvider;
    @Inject
    private Provider<ActionHandlerProvider> actionHandlerProvider;
    private FileConfiguration MVPPortalConfig;
    private WorldEditConnection worldEditConnection;
    private Map<String, PortalPlayerSession> portalSessions;
    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public static boolean UseOnMove = true;
    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public static boolean bucketFilling = true;
    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public static boolean EnforcePortalAccess = true;
    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public static boolean WandEnabled = true;
    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public static boolean ClearOnRemove = false;
    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public static boolean TeleportVehicles = true;
    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public static boolean NetherAnimation = true;
    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public static List<Material> FrameMaterials = null;

    public void onLoad() {
        super.onLoad();
        MVPLogging.init((Plugin)this);
        this.getDataFolder().mkdirs();
    }

    public void onEnable() {
        super.onEnable();
        this.initializeDependencyInjection(new MultiversePortalsPluginBinder(this));
        MVPLogging.setDebugLevel(((CoreConfig)this.coreConfig.get()).getGlobalDebug());
        this.registerCommands();
        this.portalSessions = new HashMap<String, PortalPlayerSession>();
        ((DestinationsProvider)this.destinationsProvider.get()).registerDestination((Destination)this.serviceLocator.getService(PortalDestination.class, new Annotation[0]));
        ((DestinationsProvider)this.destinationsProvider.get()).registerDestination((Destination)this.serviceLocator.getService(RandomPortalDestination.class, new Annotation[0]));
        if (!this.setupConfig()) {
            MVPLogging.severe("Your configs were not loaded.", new Object[0]);
            MVPLogging.severe("Please check your configs and restart the server.", new Object[0]);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setUpActionHandlers();
        this.loadPortals();
        this.setupMetrics();
        this.registerEvents();
        this.getServer().getPluginManager().registerEvents((Listener)new WorldEditPluginListener(), (Plugin)this);
        MultiversePortalsApi.init(this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        MVPLogging.config("Version %s (API v%s) Enabled - By %s", this.getDescription().getVersion(), this.getVersionAsNumber(), StringFormatter.joinAnd((List)this.getDescription().getAuthors()));
    }

    public void onDisable() {
        this.savePortalsConfig();
        MultiversePortalsApi.shutdown();
        this.shutdownDependencyInjection();
        MVPLogging.info("- Disabled", new Object[0]);
        MVPLogging.shutdown();
    }

    private boolean setupConfig() {
        PortalsConfig portalsConfig = (PortalsConfig)this.portalsConfigProvider.get();
        boolean loadSuccess = portalsConfig.load().andThenTry(portalsConfig::save).isSuccess();
        return loadSuccess && portalsConfig.isLoaded();
    }

    private void registerEvents() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        Try.run(() -> this.serviceLocator.getAllServices(PortalsListener.class, new Annotation[0]).forEach(listener -> pluginManager.registerEvents((Listener)listener, (Plugin)this))).onFailure(e -> {
            throw new RuntimeException("Failed to register listeners. Terminating...", (Throwable)e);
        });
        if (((PortalsConfig)this.portalsConfigProvider.get()).getTeleportVehicles()) {
            pluginManager.registerEvents((Listener)this.serviceLocator.getService(MVPVehicleListener.class, new Annotation[0]), (Plugin)this);
        }
        if (((PortalsConfig)this.portalsConfigProvider.get()).getTeleportEntities()) {
            pluginManager.registerEvents((Listener)this.serviceLocator.getService(MVPEntityPortalListener.class, new Annotation[0]), (Plugin)this);
        }
        if (((PortalsConfig)this.portalsConfigProvider.get()).getUseOnMove()) {
            pluginManager.registerEvents((Listener)this.serviceLocator.getService(MVPPlayerMoveListener.class, new Annotation[0]), (Plugin)this);
            if (((PortalsConfig)this.portalsConfigProvider.get()).getTeleportEntities()) {
                pluginManager.registerEvents((Listener)this.serviceLocator.getService(MVPEntityMoveListener.class, new Annotation[0]), (Plugin)this);
            }
        }
    }

    private void setupMetrics() {
        Try.of((CheckedFunction0 & Serializable)() -> (BstatsMetricsConfigurator)this.metricsConfiguratorProvider.get()).onFailure(e -> {
            MVPLogging.severe("Failed to setup metrics", new Object[0]);
            e.printStackTrace();
        });
    }

    public PortalPlayerSession getPortalSession(Player p) {
        return this.portalSessions.computeIfAbsent(p.getName(), s -> new PortalPlayerSession(this, p));
    }

    public void destroyPortalSession(Player p) {
        this.portalSessions.remove(p.getName());
    }

    private void setUpActionHandlers() {
        this.serviceLocator.getAllServices(ActionHandlerType.class, new Annotation[0]).forEach(handler -> ((ActionHandlerProvider)this.actionHandlerProvider.get()).registerHandlerType((ActionHandlerType<?, ?>)handler));
    }

    private void loadPortals() {
        Set keys;
        this.MVPPortalConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "portals.yml"));
        if (!this.MVPPortalConfig.isConfigurationSection("portals")) {
            this.MVPPortalConfig.createSection("portals");
        }
        if ((keys = this.MVPPortalConfig.getConfigurationSection("portals").getKeys(false)) != null) {
            for (String pname : keys) {
                MVPortal portal = MVPortal.loadMVPortalFromConfig(this, pname);
                if (portal.getPortalLocation().isValidLocation()) {
                    ((PortalManager)this.portalManager.get()).addPortal(portal);
                    continue;
                }
                MVPLogging.warning(String.format("Portal '%s' not loaded due to invalid location!", portal.getName()), new Object[0]);
            }
            MVPLogging.info(keys.size() + " - Portals(s) loaded", new Object[0]);
        }
        this.savePortalsConfig();
    }

    public boolean savePortalsConfig() {
        try {
            for (MVPortal portal : ((PortalManager)this.portalManager.get()).getAllPortals()) {
                this.MVPPortalConfig.set("portals." + portal.getName(), (Object)portal.save());
            }
            this.MVPPortalConfig.save(new File(this.getDataFolder(), "portals.yml"));
            return true;
        }
        catch (IOException e) {
            MVPLogging.severe("Failed to save Portals portals.yml.", new Object[0]);
            return false;
        }
    }

    private void registerCommands() {
        Try.run(() -> {
            this.portalsCommandCompletions.get();
            this.portalsCommandContexts.get();
        }).onFailure(e -> MVPLogging.severe("Failed to register command tools: %s", e.getMessage()));
        this.registerCommands(PortalsCommand.class);
    }

    public double getTargetCoreVersion() {
        return 5.1;
    }

    public WorldEditConnection getWorldEditConnection() {
        return this.worldEditConnection;
    }

    public FileConfiguration getPortalsConfig() {
        return this.MVPPortalConfig;
    }

    public void reloadConfigs() {
        this.reloadConfigs(true);
    }

    public void reloadConfigs(boolean reloadPortals) {
        if (reloadPortals) {
            ((PortalManager)this.portalManager.get()).removeAll(false);
            this.loadPortals();
        }
        PluginManager pm = this.getServer().getPluginManager();
        boolean previousTeleportVehicles = ((PortalsConfig)this.portalsConfigProvider.get()).getTeleportVehicles();
        boolean previousUseOnMove = ((PortalsConfig)this.portalsConfigProvider.get()).getUseOnMove();
        this.setupConfig();
        if (((PortalsConfig)this.portalsConfigProvider.get()).getTeleportVehicles() != previousTeleportVehicles) {
            if (((PortalsConfig)this.portalsConfigProvider.get()).getTeleportVehicles()) {
                pm.registerEvents((Listener)this.serviceLocator.getService(MVPVehicleListener.class, new Annotation[0]), (Plugin)this);
            } else {
                VehicleMoveEvent.getHandlerList().unregister((Plugin)this);
            }
        }
        if (((PortalsConfig)this.portalsConfigProvider.get()).getUseOnMove() != previousUseOnMove) {
            if (((PortalsConfig)this.portalsConfigProvider.get()).getUseOnMove()) {
                pm.registerEvents((Listener)this.serviceLocator.getService(MVPPlayerMoveListener.class, new Annotation[0]), (Plugin)this);
            } else {
                BlockFromToEvent.getHandlerList().unregister((Plugin)this);
                PlayerMoveEvent.getHandlerList().unregister((Plugin)this);
            }
        }
    }

    public boolean isWandEnabled() {
        return WandEnabled;
    }

    public void setWandEnabled(boolean enabled) {
        WandEnabled = enabled;
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public void loadConfig() {
        this.setupConfig();
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public boolean saveMainConfig() {
        return ((PortalsConfig)this.portalsConfigProvider.get()).save().isSuccess();
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public FileConfiguration getMainConfig() {
        return ((PortalsConfig)this.portalsConfigProvider.get()).getConfig();
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public long getCooldownTime() {
        return ((PortalsConfig)this.portalsConfigProvider.get()).getPortalCooldown();
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public Material getWandMaterial() {
        return ((PortalsConfig)this.portalsConfigProvider.get()).getWandMaterial();
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public String getVersionInfo() {
        return "[Multiverse-Portals] Multiverse-Portals Version: " + this.getDescription().getVersion() + "\n[Multiverse-Portals] Loaded Portals: " + ((PortalManager)this.portalManager.get()).getAllPortals().size() + "\n[Multiverse-Portals] Special Code: FRN001\n";
    }

    private class WorldEditPluginListener
    implements Listener {
        private WorldEditPluginListener() {
            if (MultiversePortals.this.getServer().getPluginManager().getPlugin("WorldEdit") != null) {
                this.connectWorldEdit();
            }
        }

        private boolean isPluginWorldEdit(Plugin plugin) {
            if (plugin == null) {
                throw new RuntimeException("plugin must not be null.");
            }
            return plugin.getName().equals("WorldEdit");
        }

        private void connectWorldEdit() {
            MultiversePortals.this.worldEditConnection = new WorldEditConnection((Plugin)MultiversePortals.this);
            MultiversePortals.this.worldEditConnection.connect();
        }

        @EventHandler
        private void pluginEnabled(PluginEnableEvent event) {
            if (this.isPluginWorldEdit(event.getPlugin())) {
                this.connectWorldEdit();
            }
        }

        @EventHandler
        private void pluginDisableEvent(PluginDisableEvent event) {
            if (this.isPluginWorldEdit(event.getPlugin())) {
                MultiversePortals.this.worldEditConnection.disconnect();
                MultiversePortals.this.worldEditConnection = null;
            }
        }
    }
}

