/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.core.config.node.ConfigNode;
import org.mvplugins.multiverse.core.config.node.Node;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.core.exceptions.MultiverseException;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.PortalLocation;
import org.mvplugins.multiverse.portals.action.ActionHandler;
import org.mvplugins.multiverse.portals.action.ActionHandlerProvider;
import org.mvplugins.multiverse.portals.utils.MultiverseRegion;

final class MVPortalNodes {
    private final NodeGroup nodes = new NodeGroup();
    private MultiversePortals plugin;
    private MVPortal portal;
    private ActionHandlerProvider actionHandlerProvider;
    final ConfigNode<Material> currency = this.node(ConfigNode.builder((String)"currency", Material.class).defaultValue((Object)Material.AIR).aliases(new String[]{"curr"}).build());
    final ConfigNode<Double> price = this.node(ConfigNode.builder((String)"price", Double.class).defaultValue((Object)0.0).build());
    final ConfigNode<Boolean> safeTeleport = this.node(ConfigNode.builder((String)"safe-teleport", Boolean.class).defaultValue((Object)true).aliases(new String[]{"safe"}).build());
    final ConfigNode<Boolean> teleportNonPlayers = this.node(ConfigNode.builder((String)"teleport-non-players", Boolean.class).defaultValue((Object)false).aliases(new String[]{"telenonplayers"}).build());
    final ConfigNode<String> owner = this.node(ConfigNode.builder((String)"owner", String.class).defaultValue((Object)"").build());
    final ConfigNode<String> location = this.node(ConfigNode.builder((String)"location", String.class).defaultValue((Object)"").aliases(new String[]{"loc"}).suggester((sender, input) -> {
        Player player;
        if (sender instanceof Player && this.plugin.getPortalSession(player = (Player)sender).getSelectedRegion() != null) {
            return List.of("@selected-region");
        }
        return Collections.emptyList();
    }).stringParser((sender, input, type) -> {
        if (input.equals("@selected-region")) {
            if (!(sender instanceof Player)) {
                return Try.failure((Throwable)new MultiverseException("You can only use '@selected-region' as a player."));
            }
            Player player = (Player)sender;
            MultiverseRegion region = this.plugin.getPortalSession(player).getSelectedRegion();
            if (region == null) {
                return Try.failure((Throwable)new MultiverseException("You must select a region first. See `/mvp wand` for more info."));
            }
            return Try.success((Object)region.toString());
        }
        PortalLocation portalLocation = PortalLocation.parseLocation(input);
        if (!portalLocation.isValidLocation()) {
            return Try.failure((Throwable)new MultiverseException("Invalid location format. The portal location must be in the format `WORLD:X,Y,Z:X,Y,Z`."));
        }
        return Try.success((Object)portalLocation.toString());
    }).onSetValue((oldValue, newValue) -> this.portal.setPortalLocationInternal(PortalLocation.parseLocation(newValue))).build());
    final ConfigNode<String> actionType = this.node(ConfigNode.builder((String)"action-type", String.class).suggester(input -> this.actionHandlerProvider.getAllHandlerTypeNames()).defaultValue((Object)"multiverse-destination").build());
    final ConfigNode<String> action = this.node(ConfigNode.builder((String)"action", String.class).defaultValue((Object)"").aliases(new String[]{"destination", "dest"}).suggester((sender, input) -> (Collection)this.actionHandlerProvider.getHandlerType(this.portal.getActionType()).map(actionHandlerType -> actionHandlerType.suggestActions(sender, input)).getOrElse(Collections.emptyList())).stringParser((sender, input, type) -> Try.of((CheckedFunction0 & Serializable)() -> (String)this.actionHandlerProvider.getHandlerType(this.portal.getActionType()).mapAttempt(actionHandlerType -> actionHandlerType.parseHandler(sender, input)).map(ActionHandler::serialise).getOrThrow(failure -> new MultiverseException(failure.getFailureMessage())))).build());
    final ConfigNode<Boolean> checkDestinationSafety = this.node(ConfigNode.builder((String)"check-destination-safety", Boolean.class).defaultValue((Object)true).build());
    final ConfigNode<Double> version = this.node(ConfigNode.builder((String)"version", Double.class).defaultValue((Object)0.0).hidden().build());

    MVPortalNodes(MultiversePortals plugin, MVPortal portal) {
        this.plugin = plugin;
        this.portal = portal;
        this.actionHandlerProvider = (ActionHandlerProvider)plugin.getServiceLocator().getService(ActionHandlerProvider.class, new Annotation[0]);
    }

    NodeGroup getNodes() {
        return this.nodes;
    }

    private <N extends Node> N node(N node) {
        this.nodes.add(node);
        return node;
    }
}

