/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.config.handle.BaseConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.MemoryConfigurationHandle;
import org.mvplugins.multiverse.core.config.handle.StringPropertyHandle;
import org.mvplugins.multiverse.core.config.migration.ConfigMigrator;
import org.mvplugins.multiverse.core.config.migration.VersionMigrator;
import org.mvplugins.multiverse.core.config.migration.action.MigratorAction;
import org.mvplugins.multiverse.core.config.migration.action.MoveMigratorAction;
import org.mvplugins.multiverse.core.config.node.NodeGroup;
import org.mvplugins.multiverse.core.destination.DestinationInstance;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.teleportation.BlockSafety;
import org.mvplugins.multiverse.core.utils.result.Attempt;
import org.mvplugins.multiverse.core.utils.text.ChatTextFormatter;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.commands.CommandIssuer;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.portals.MVPortalNodes;
import org.mvplugins.multiverse.portals.MultiversePortals;
import org.mvplugins.multiverse.portals.PortalLocation;
import org.mvplugins.multiverse.portals.action.ActionFailureReason;
import org.mvplugins.multiverse.portals.action.ActionHandler;
import org.mvplugins.multiverse.portals.action.ActionHandlerProvider;
import org.mvplugins.multiverse.portals.action.ActionHandlerType;
import org.mvplugins.multiverse.portals.config.PortalsConfig;
import org.mvplugins.multiverse.portals.enums.PortalType;
import org.mvplugins.multiverse.portals.util.MVPLogging;
import org.mvplugins.multiverse.portals.utils.MultiverseRegion;

public final class MVPortal {
    private static final Collection<Material> INTERIOR_MATERIALS = Arrays.asList(Material.NETHER_PORTAL, Material.GRASS, Material.VINE, Material.SNOW, Material.AIR, Material.WATER, Material.LAVA);
    public static final Pattern PORTAL_NAME_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+");
    private final MultiversePortals plugin;
    private final PortalsConfig portalsConfig;
    private final WorldManager worldManager;
    private final DestinationsProvider destinationsProvider;
    private final BlockSafety blockSafety;
    private final ActionHandlerProvider actionHandlerProvider;
    private final MVCommandManager commandManager;
    private final String name;
    private final MVPortalNodes configNodes;
    private final MemoryConfigurationHandle configHandle;
    private final StringPropertyHandle stringPropertyHandle;
    private PortalLocation location;
    private Permission permission;
    private Permission fillPermission;
    private Permission exempt;

    public static boolean isPortalInterior(Material material) {
        return INTERIOR_MATERIALS.contains(material);
    }

    public static MVPortal loadMVPortalFromConfig(MultiversePortals instance, String name) {
        return new MVPortal(instance, name);
    }

    public MVPortal(LoadedMultiverseWorld world, MultiversePortals instance, String name, String owner, String location) {
        this(instance, name);
        this.setOwner(owner);
        this.setPortalLocation(location, world);
    }

    public MVPortal(MultiversePortals plugin, String name, String owner, PortalLocation location) {
        this(plugin, name);
        this.setOwner(owner);
        this.setPortalLocation(location);
    }

    private MVPortal(MultiversePortals plugin, String name) {
        this.plugin = plugin;
        this.portalsConfig = (PortalsConfig)this.plugin.getServiceLocator().getService(PortalsConfig.class, new Annotation[0]);
        this.worldManager = (WorldManager)this.plugin.getServiceLocator().getService(WorldManager.class, new Annotation[0]);
        this.destinationsProvider = (DestinationsProvider)this.plugin.getServiceLocator().getService(DestinationsProvider.class, new Annotation[0]);
        this.blockSafety = (BlockSafety)this.plugin.getServiceLocator().getService(BlockSafety.class, new Annotation[0]);
        this.actionHandlerProvider = (ActionHandlerProvider)this.plugin.getServiceLocator().getService(ActionHandlerProvider.class, new Annotation[0]);
        this.commandManager = (MVCommandManager)this.plugin.getServiceLocator().getService(MVCommandManager.class, new Annotation[0]);
        this.name = name;
        FileConfiguration config = this.plugin.getPortalsConfig();
        this.configNodes = new MVPortalNodes(plugin, this);
        ConfigurationSection portalSection = (ConfigurationSection)Option.of((Object)config.getConfigurationSection("portals." + this.name)).getOrElse(() -> config.createSection("portals." + this.name));
        this.configHandle = this.setUpConfigHandle(portalSection);
        this.stringPropertyHandle = new StringPropertyHandle((BaseConfigurationHandle)this.configHandle);
        this.configHandle.load();
        this.setUpPermissions();
    }

    private MemoryConfigurationHandle setUpConfigHandle(ConfigurationSection portalSection) {
        return ((MemoryConfigurationHandle.Builder)MemoryConfigurationHandle.builder((ConfigurationSection)portalSection, (NodeGroup)this.configNodes.getNodes()).migrator(ConfigMigrator.builder(this.configNodes.version).addVersionMigrator(VersionMigrator.builder((double)1.0).addAction((MigratorAction)MoveMigratorAction.of((String)"safeteleport", (String)"safe-teleport")).addAction((MigratorAction)MoveMigratorAction.of((String)"teleportnonplayers", (String)"teleport-non-players")).build()).addVersionMigrator(VersionMigrator.builder((double)1.1).addAction(configSection -> {
            String world = configSection.getString("world");
            String location = configSection.getString("location");
            if (world != null && location != null) {
                configSection.set("location", (Object)(world + ":" + location));
            }
        }).build()).addVersionMigrator(VersionMigrator.builder((double)1.2).addAction((MigratorAction)MoveMigratorAction.of((String)"destination", (String)"action")).build()).build())).build();
    }

    private void setUpPermissions() {
        this.permission = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.access." + this.name);
        if (this.permission == null) {
            this.permission = new Permission("multiverse.portal.access." + this.name, "Allows access to the " + this.name + " portal", PermissionDefault.OP);
            this.plugin.getServer().getPluginManager().addPermission(this.permission);
        }
        this.fillPermission = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.fill." + this.name);
        if (this.fillPermission == null) {
            this.fillPermission = new Permission("multiverse.portal.fill." + this.name, "Allows filling the " + this.name + " portal", PermissionDefault.OP);
            this.plugin.getServer().getPluginManager().addPermission(this.fillPermission);
        }
        this.exempt = this.plugin.getServer().getPluginManager().getPermission("multiverse.portal.exempt." + this.name);
        if (this.exempt == null) {
            this.exempt = new Permission("multiverse.portal.exempt." + this.name, "A player who has this permission will not pay to use this portal " + this.name + " portal", PermissionDefault.FALSE);
            this.plugin.getServer().getPluginManager().addPermission(this.exempt);
        }
    }

    public String getName() {
        return this.name;
    }

    @ApiStatus.AvailableSince(value="5.1")
    public StringPropertyHandle getStringPropertyHandle() {
        return this.stringPropertyHandle;
    }

    ConfigurationSection save() {
        this.configHandle.save();
        return this.configHandle.getConfig();
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean setOwner(String owner) {
        return this.configHandle.set(this.configNodes.owner, (Object)owner).isSuccess();
    }

    @ApiStatus.AvailableSince(value="5.1")
    public String getOwner() {
        return (String)this.configHandle.get(this.configNodes.owner);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public void setTeleportNonPlayers(boolean teleportNonPlayers) {
        this.configHandle.set(this.configNodes.teleportNonPlayers, (Object)teleportNonPlayers);
    }

    public boolean getTeleportNonPlayers() {
        return (Boolean)this.configHandle.get(this.configNodes.teleportNonPlayers);
    }

    private void setUseSafeTeleporter(boolean teleport) {
        this.configHandle.set(this.configNodes.safeTeleport, (Object)teleport);
    }

    public boolean useSafeTeleporter() {
        return (Boolean)this.configHandle.get(this.configNodes.safeTeleport);
    }

    private boolean setCurrency(Material currency) {
        return this.configHandle.set(this.configNodes.currency, (Object)currency).isSuccess();
    }

    public Material getCurrency() {
        return (Material)this.configHandle.get(this.configNodes.currency);
    }

    private boolean setPrice(double price) {
        return this.configHandle.set(this.configNodes.price, (Object)price).isSuccess();
    }

    public double getPrice() {
        return (Double)this.configHandle.get(this.configNodes.price);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean setPortalLocation(String locationString) {
        return this.setPortalLocation(PortalLocation.parseLocation(locationString));
    }

    public boolean setPortalLocation(String locationString, String worldString) {
        LoadedMultiverseWorld world = null;
        if (this.worldManager.isWorld(worldString)) {
            world = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(worldString).getOrNull();
        }
        return this.setPortalLocation(locationString, world);
    }

    public boolean setPortalLocation(String locationString, LoadedMultiverseWorld world) {
        return this.setPortalLocation(PortalLocation.parseLocation(locationString, world, this.name));
    }

    public boolean setPortalLocation(PortalLocation location) {
        if (!this.setPortalLocationInternal(location)) {
            return false;
        }
        return this.configHandle.set(this.configNodes.location, (Object)this.location.toString()).isSuccess();
    }

    boolean setPortalLocationInternal(PortalLocation location) {
        this.location = location;
        if (!this.location.isValidLocation()) {
            MVPLogging.warning("Portal " + this.name + " has an invalid LOCATION!", new Object[0]);
            return false;
        }
        return true;
    }

    public PortalLocation getPortalLocation() {
        if (this.location == null) {
            this.location = PortalLocation.parseLocation((String)this.configHandle.get(this.configNodes.location));
        }
        return this.location;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public Try<Void> setActionType(@NotNull ActionHandlerType<?, ?> actionType) {
        Objects.requireNonNull(actionType, "actionType cannot be null");
        return this.configHandle.set(this.configNodes.actionType, (Object)actionType.getName());
    }

    @ApiStatus.AvailableSince(value="5.2")
    public Try<Void> setActionType(String actionType) {
        return this.configHandle.set(this.configNodes.actionType, (Object)actionType);
    }

    @ApiStatus.AvailableSince(value="5.2")
    public String getActionType() {
        return (String)this.configHandle.get(this.configNodes.actionType);
    }

    @ApiStatus.AvailableSince(value="5.2")
    public Try<Void> setAction(String action) {
        return this.configHandle.set(this.configNodes.action, (Object)action);
    }

    @ApiStatus.AvailableSince(value="5.2")
    public String getAction() {
        return (String)this.configHandle.get(this.configNodes.action);
    }

    @ApiStatus.AvailableSince(value="5.2")
    public Try<Void> setActionHandler(@NotNull ActionHandler<?, ?> action) {
        Objects.requireNonNull(action, "action cannot be null");
        return this.setActionType((ActionHandlerType<?, ?>)action.getHandlerType()).flatMap(v -> this.setAction(action.serialise()));
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public Attempt<? extends ActionHandler<?, ?>, ActionFailureReason> getActionHandler() {
        return this.actionHandlerProvider.parseHandler(this.getActionType(), this.getAction());
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public Attempt<? extends ActionHandler<?, ?>, ActionFailureReason> getActionHandler(@NotNull CommandSender sender) {
        return this.actionHandlerProvider.parseHandler(sender, this.getActionType(), this.getAction());
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public Attempt<Void, ActionFailureReason> runActionFor(Entity entity) {
        return this.getActionHandler((CommandSender)entity).mapAttempt(actionHandler -> actionHandler.runAction(this, entity)).onSuccess(() -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.plugin.getPortalSession(player).setTeleportTime(new Date());
            }
        }).onFailure(failure -> MVPLogging.warning(ChatTextFormatter.removeColor((String)("Invalid Portal Action: " + failure.getFailureMessage().formatted((CommandIssuer)this.commandManager.getCommandIssuer((Object)Bukkit.getConsoleSender())))), new Object[0]));
    }

    @ApiStatus.AvailableSince(value="5.1")
    public Try<Void> setCheckDestinationSafety(boolean checkDestinationSafety) {
        return this.configHandle.set(this.configNodes.checkDestinationSafety, (Object)checkDestinationSafety);
    }

    @ApiStatus.AvailableSince(value="5.1")
    public boolean getCheckDestinationSafety() {
        return (Boolean)this.configHandle.get(this.configNodes.checkDestinationSafety);
    }

    public Location getSafePlayerSpawnLocation() {
        PortalLocation pl = this.location;
        double portalWidth = Math.abs(pl.getMaximum().getBlockX() - pl.getMinimum().getBlockX()) + 1;
        double portalDepth = Math.abs(pl.getMaximum().getBlockZ() - pl.getMinimum().getBlockZ()) + 1;
        double finalX = portalWidth / 2.0 + (double)pl.getMinimum().getBlockX();
        double finalZ = portalDepth / 2.0 + (double)pl.getMinimum().getBlockZ();
        double finalY = this.getMinimumWith2Air((int)finalX, (int)finalZ, pl.getMinimum().getBlockY(), pl.getMaximum().getBlockY(), this.getWorld());
        return new Location(this.getWorld(), finalX, finalY, finalZ);
    }

    private double getMinimumWith2Air(int finalX, int finalZ, int y, int yMax, World w) {
        for (int i = y; i < yMax; ++i) {
            if (!this.blockSafety.canSpawnAtLocationSafely(new Location(w, (double)finalX, (double)i, (double)finalZ))) continue;
            return i;
        }
        return y;
    }

    public Material getFillMaterial() throws IllegalStateException {
        if (!this.location.isValidLocation()) {
            throw new IllegalStateException(String.format("Failed to get fill material from MV Portal (%s): Portal location is invalid.", this.getName()));
        }
        return this.location.getMinimum().getMidpoint(this.location.getMaximum()).toLocation((World)this.location.getMVWorld().getBukkitWorld().getOrNull()).getBlock().getType();
    }

    public PortalType getPortalType() throws IllegalStateException {
        if (this.getFillMaterial() == Material.NETHER_PORTAL) {
            return PortalType.Normal;
        }
        return PortalType.Legacy;
    }

    public boolean isLegacyPortal() throws IllegalStateException {
        return this.getPortalType() == PortalType.Legacy;
    }

    public boolean playerCanEnterPortal(Player player) {
        return player.hasPermission(this.permission);
    }

    public boolean playerCanFillPortal(Player player) {
        return player.hasPermission(this.fillPermission);
    }

    @Nullable
    public World getWorld() {
        LoadedMultiverseWorld mvWorld = this.location.getMVWorld();
        if (mvWorld == null) {
            return null;
        }
        return (World)mvWorld.getBukkitWorld().getOrNull();
    }

    public Permission getPermission() {
        return this.permission;
    }

    public Permission getFillPermission() {
        return this.fillPermission;
    }

    public Permission getExempt() {
        return this.exempt;
    }

    public void removePermission() {
        this.plugin.getServer().getPluginManager().removePermission(this.permission);
    }

    public boolean isFrameValid(Location l) {
        boolean useZ;
        List<Material> validMaterials = this.portalsConfig.getFrameMaterials();
        if (validMaterials == null || validMaterials.isEmpty()) {
            return true;
        }
        MVPLogging.finer(String.format("checking portal frame at %d,%d,%d", l.getBlockX(), l.getBlockY(), l.getBlockZ()), new Object[0]);
        boolean frameValid = false;
        MultiverseRegion r = this.getPortalLocation().getRegion();
        boolean useX = r.getWidth() != 1;
        boolean useY = r.getHeight() != 1;
        boolean bl = useZ = r.getDepth() != 1;
        if (!frameValid && !useX) {
            frameValid = this.isFrameValid(l, this.expandedRegion(r, 0, 1, 1));
        }
        if (!frameValid && !useY) {
            frameValid = this.isFrameValid(l, this.expandedRegion(r, 1, 0, 1));
        }
        if (!frameValid && !useZ) {
            frameValid = this.isFrameValid(l, this.expandedRegion(r, 1, 1, 0));
        }
        return frameValid;
    }

    private boolean isFrameValid(Location location, MultiverseRegion searchRegion) {
        int useZ;
        int useX = searchRegion.getWidth() == 1 ? 0 : 1;
        int useY = searchRegion.getHeight() == 1 ? 0 : 1;
        int n = useZ = searchRegion.getDepth() == 1 ? 0 : 1;
        if (useX + useY + useZ != 2) {
            return false;
        }
        MVPLogging.finer(String.format("checking portal around %d,%d,%d", location.getBlockX(), location.getBlockY(), location.getBlockZ()), new Object[0]);
        Material commonMaterial = null;
        World world = location.getWorld();
        HashSet<Location> visited = new HashSet<Location>();
        Stack<Location> frontier = new Stack<Location>();
        frontier.push(location);
        while (!frontier.isEmpty()) {
            Location toCheck = (Location)frontier.pop();
            visited.add(toCheck);
            MVPLogging.finer(String.format("          ... block at %d,%d,%d", toCheck.getBlockX(), toCheck.getBlockY(), toCheck.getBlockZ()), new Object[0]);
            if (MVPortal.isPortalInterior(toCheck.getBlock().getType())) {
                for (int d1 = -1; d1 <= 1; ++d1) {
                    for (int d2 = -1; d2 <= 1; ++d2) {
                        int newZ;
                        int newY;
                        if (!(d1 == 0 ^ d2 == 0)) continue;
                        int dx = useX * d1;
                        int dy = useY * (useX == 0 ? d1 : d2);
                        int dz = useZ * d2;
                        int newX = toCheck.getBlockX() + dx;
                        Location toVisit = new Location(world, (double)newX, (double)(newY = toCheck.getBlockY() + dy), (double)(newZ = toCheck.getBlockZ() + dz));
                        if (!searchRegion.containsVector(toVisit)) {
                            return false;
                        }
                        if (visited.contains(toVisit)) continue;
                        frontier.add(toVisit);
                    }
                }
                continue;
            }
            Material material = toCheck.getBlock().getType();
            if (commonMaterial == null) {
                commonMaterial = material;
                continue;
            }
            if (commonMaterial == material) continue;
            MVPLogging.finer("frame has multiple materials", new Object[0]);
            return false;
        }
        MVPLogging.finer(String.format("frame has common material %s", commonMaterial), new Object[0]);
        return this.portalsConfig.getFrameMaterials().contains(commonMaterial);
    }

    private MultiverseRegion expandedRegion(MultiverseRegion r, int x, int y, int z) {
        Vector min = new Vector().copy(r.getMinimumPoint());
        Vector max = new Vector().copy(r.getMaximumPoint());
        min.add(new Vector(-x, -y, -z));
        max.add(new Vector(x, y, z));
        return new MultiverseRegion(min, max, r.getWorld());
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public boolean setProperty(String property, String value) {
        return this.stringPropertyHandle.setPropertyString(property, value).isSuccess();
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public String getHandlerScript() {
        MVPLogging.warning("handle script is deprecated", new Object[0]);
        return "";
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public void setHandlerScript(String handlerScript) {
        MVPLogging.warning("handle script is deprecated", new Object[0]);
    }

    @Deprecated(since="5.1", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public boolean isExempt(Player player) {
        return false;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public PortalLocation getLocation() {
        return this.getPortalLocation();
    }

    @Deprecated(since="5.2", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public boolean setDestination(String destinationString) {
        DestinationInstance newDestination = (DestinationInstance)this.destinationsProvider.parseDestination(destinationString).getOrNull();
        return this.setDestination(newDestination);
    }

    @Deprecated(since="5.2", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    public boolean setDestination(DestinationInstance<?, ?> newDestination) {
        if (newDestination == null) {
            MVPLogging.warning("Portal " + this.name + " has an invalid DESTINATION!", new Object[0]);
            return false;
        }
        if (!Objects.equals(this.getActionType(), "multiverse-destination")) {
            MVPLogging.warning("Portal " + this.name + " is not set to use multiverse destination!", new Object[0]);
            return false;
        }
        return this.setActionType("multiverse-destination").flatMap(ignore -> this.setAction(newDestination.toString())).isSuccess();
    }

    @Deprecated(since="5.2", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="6.0")
    @Nullable
    public DestinationInstance<?, ?> getDestination() {
        return (DestinationInstance)this.destinationsProvider.parseDestination(this.getAction()).onFailure(f -> {
            if (this.getAction().equals("multiverse-destination")) {
                MVPLogging.warning("Portal " + this.name + " has an invalid DESTINATION! " + f.getFailureMessage().formatted(), new Object[0]);
            }
        }).getOrNull();
    }
}

