/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.portals.commands;

import org.bukkit.ChatColor;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.portals.MVPortal;
import org.mvplugins.multiverse.portals.commands.PortalsCommand;
import org.mvplugins.multiverse.portals.utils.PortalManager;

@Service
class RemoveCommand
extends PortalsCommand {
    private final PortalManager portalManager;

    @Inject
    RemoveCommand(@NotNull PortalManager portalManager) {
        this.portalManager = portalManager;
    }

    @Subcommand(value="remove")
    @CommandPermission(value="multiverse.portal.remove")
    @CommandCompletion(value="@mvportals")
    @Syntax(value="<portal-name>")
    @Description(value="Removes a existing portal.")
    void onRemoveCommand(MVCommandIssuer issuer, @Syntax(value="<portal-name>") @Description(value="The name of the portal to remove.") String portalName) {
        if (!this.portalManager.isPortal(portalName)) {
            issuer.sendMessage("The portal Portal " + String.valueOf(ChatColor.DARK_AQUA) + portalName + String.valueOf(ChatColor.WHITE) + " does NOT exist!");
            return;
        }
        MVPortal portal = this.portalManager.removePortal(portalName, true);
        issuer.sendMessage("Portal " + String.valueOf(ChatColor.DARK_AQUA) + portal.getName() + String.valueOf(ChatColor.WHITE) + " was removed successfully!");
    }

    @Service
    private static final class LegacyAlias
    extends RemoveCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(PortalManager portalManager) {
            super(portalManager);
        }

        @Override
        @CommandAlias(value="mvpremove|mvpr")
        void onRemoveCommand(MVCommandIssuer issuer, String portalName) {
            super.onRemoveCommand(issuer, portalName);
        }
    }
}

