/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals.utils;

import org.bukkit.PortalType;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.netherportals.MultiverseNetherPortals;
import org.mvplugins.multiverse.netherportals.util.MVPLogging;

@Service
public class MVNameChecker {
    private final MultiverseNetherPortals plugin;
    private final WorldManager worldManager;

    @Inject
    MVNameChecker(@NotNull MultiverseNetherPortals plugin, @NotNull WorldManager worldManager) {
        this.plugin = plugin;
        this.worldManager = worldManager;
    }

    public boolean isValidNetherName(String world) {
        try {
            if (world.matches("^" + this.plugin.getNetherPrefix() + ".+" + this.plugin.getNetherSuffix() + "$")) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public boolean isValidEndName(String world) {
        try {
            if (world.matches("^" + this.plugin.getEndPrefix() + ".+" + this.plugin.getEndSuffix() + "$")) {
                return true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public String getNetherName(String normalName) {
        String netherName = this.plugin.getNetherPrefix() + normalName + this.plugin.getNetherSuffix();
        if (this.worldManager.isLoadedWorld(netherName)) {
            MVPLogging.finest("Selected nether world '" + netherName + "' for normal '" + normalName + "'", new Object[0]);
        }
        return netherName;
    }

    public String getEndName(String normalName) {
        String endName = this.plugin.getEndPrefix() + normalName + this.plugin.getEndSuffix();
        if (this.worldManager.isLoadedWorld(endName)) {
            MVPLogging.finest("Selected end world '" + endName + "' for normal '" + normalName + "'", new Object[0]);
        }
        return endName;
    }

    public String getNormalName(String netherName, PortalType type) {
        String normalName = netherName;
        if (type == PortalType.NETHER) {
            String[] split;
            if (!this.plugin.getNetherPrefix().isEmpty()) {
                split = normalName.split(this.plugin.getNetherPrefix());
                normalName = split[1];
            }
            if (!this.plugin.getNetherSuffix().isEmpty()) {
                split = normalName.split(this.plugin.getNetherSuffix());
                normalName = split[0];
            }
        } else if (type == PortalType.ENDER) {
            String[] split;
            if (!this.plugin.getNetherPrefix().isEmpty()) {
                split = normalName.split(this.plugin.getEndPrefix());
                normalName = split[1];
            }
            if (!this.plugin.getNetherSuffix().isEmpty()) {
                split = normalName.split(this.plugin.getEndSuffix());
                normalName = split[0];
            }
        }
        if (!normalName.equals(netherName) && this.worldManager.isLoadedWorld(normalName)) {
            MVPLogging.finest("Selected normal world '" + normalName + "' for " + String.valueOf(type) + " '" + netherName + "'", new Object[0]);
        }
        return normalName;
    }
}

