/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals.utils;

import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.entrycheck.WorldEntryCheckerProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.netherportals.util.MVPLogging;

@Service
public class MVLinkChecker {
    private final WorldManager worldManager;
    private final WorldEntryCheckerProvider entryCheckerProvider;

    @Inject
    MVLinkChecker(WorldManager worldManager, WorldEntryCheckerProvider entryCheckerProvider) {
        this.worldManager = worldManager;
        this.entryCheckerProvider = entryCheckerProvider;
    }

    public Location findNewTeleportLocation(Location fromLocation, String worldString, Entity e) {
        LoadedMultiverseWorld tpFrom = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(fromLocation.getWorld()).getOrNull();
        LoadedMultiverseWorld tpTo = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(worldString).getOrNull();
        if (tpTo == null) {
            MVPLogging.fine("Can't find world " + worldString, new Object[0]);
        } else if (!this.worldManager.isLoadedWorld(fromLocation.getWorld())) {
            MVPLogging.warning("World " + fromLocation.getWorld().getName() + " is not a Multiverse world", new Object[0]);
        } else {
            String entityType = e instanceof Player ? " player " : " entity ";
            MVPLogging.fine("Finding new teleport location for" + entityType + e.getName() + " to world " + worldString, new Object[0]);
            double fromScaling = tpFrom.getScale();
            double toScaling = tpTo.getScale();
            this.scaleLocation(fromLocation, fromScaling / toScaling);
            fromLocation.setWorld((World)tpTo.getBukkitWorld().getOrNull());
            return fromLocation;
        }
        return null;
    }

    private void scaleLocation(Location fromLocation, double scaling) {
        fromLocation.setX(fromLocation.getX() * scaling);
        fromLocation.setZ(fromLocation.getZ() * scaling);
    }
}

