/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.PortalType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.netherportals.MultiverseNetherPortals;
import org.mvplugins.multiverse.netherportals.runnables.PlayerTouchingPortalTask;

@Service
public class MVEventRecord {
    private final MultiverseNetherPortals plugin;
    private final Map<UUID, BukkitTask> ender;
    private final Map<UUID, BukkitTask> nether;

    @Inject
    MVEventRecord(MultiverseNetherPortals plugin) {
        this.plugin = plugin;
        this.ender = new HashMap<UUID, BukkitTask>();
        this.nether = new HashMap<UUID, BukkitTask>();
    }

    private Map<UUID, BukkitTask> getPortalRecord(PortalType type) {
        switch (type) {
            case ENDER: {
                return this.ender;
            }
            case NETHER: {
                return this.nether;
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean isInRecord(PortalType portalType, UUID uuid) {
        Map<UUID, BukkitTask> portalRecord = this.getPortalRecord(portalType);
        return portalRecord.containsKey(uuid);
    }

    public void addToRecord(PortalType portalType, UUID uuid) {
        Map<UUID, BukkitTask> portalRecord = this.getPortalRecord(portalType);
        if (portalRecord.containsKey(uuid)) {
            return;
        }
        portalRecord.put(uuid, new PlayerTouchingPortalTask(this, portalType, uuid).runTaskTimer((Plugin)this.plugin, 200L, 200L));
    }

    public void removeFromRecord(PortalType portalType, UUID uuid) {
        Map<UUID, BukkitTask> portalRecord = this.getPortalRecord(portalType);
        if (portalRecord.containsKey(uuid)) {
            portalRecord.remove(uuid).cancel();
        }
    }
}

