/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals.utils;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.netherportals.util.MVPLogging;

@Service
public class EndPlatformCreator {
    public void createEndPlatform(World world, boolean dropEndBlocks) {
        Block spawnLocation = new Location(world, 100.0, 49.0, 0.0).getBlock();
        MVPLogging.fine("Creating an end platform at " + String.valueOf(spawnLocation), new Object[0]);
        for (int x = spawnLocation.getX() - 2; x <= spawnLocation.getX() + 2; ++x) {
            for (int z = spawnLocation.getZ() - 2; z <= spawnLocation.getZ() + 2; ++z) {
                Block platformBlock = spawnLocation.getWorld().getBlockAt(x, spawnLocation.getY() - 1, z);
                MVPLogging.finest("Placing blocks at " + String.valueOf(platformBlock), new Object[0]);
                if (platformBlock.getType() != Material.OBSIDIAN) {
                    platformBlock.setType(Material.OBSIDIAN);
                    MVPLogging.finest("Placing obsidian at " + String.valueOf(platformBlock), new Object[0]);
                }
                for (int yMod = 1; yMod <= 3; ++yMod) {
                    Block block = platformBlock.getRelative(BlockFace.UP, yMod);
                    if (block.getType() == Material.AIR) continue;
                    if (!dropEndBlocks || !block.breakNaturally()) {
                        block.setType(Material.AIR);
                    }
                    MVPLogging.finest("Breaking block at " + String.valueOf(block), new Object[0]);
                }
            }
        }
    }

    public Location getVanillaLocation(Entity entity, World world) {
        return entity instanceof Player ? new Location(world, 100.0, 49.0, 0.0, 90.0f, 0.0f) : new Location(world, 100.5, 50.0, 0.5, 90.0f, 0.0f);
    }

    public Location getVanillaLocation(Entity entity, LoadedMultiverseWorld world) {
        return this.getVanillaLocation(entity, (World)world.getBukkitWorld().getOrNull());
    }
}

