/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals.listeners;

import java.io.Serializable;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.netherportals.MultiverseNetherPortals;
import org.mvplugins.multiverse.netherportals.listeners.MVNPListener;
import org.mvplugins.multiverse.netherportals.util.MVPLogging;
import org.mvplugins.multiverse.netherportals.utils.EndPlatformCreator;
import org.mvplugins.multiverse.netherportals.utils.MVLinkChecker;
import org.mvplugins.multiverse.netherportals.utils.MVNameChecker;

@Service
final class MVNPPlayerListener
implements MVNPListener {
    private final MultiverseNetherPortals plugin;
    private final MVNameChecker nameChecker;
    private final MVLinkChecker linkChecker;
    private final WorldManager worldManager;
    private final EndPlatformCreator endPlatformCreator;
    private final Advancement enterNetherAdvancement;
    private final Advancement enterEndAdvancement;
    private static final String ENTER_NETHER_CRITERIA = "entered_nether";
    private static final String ENTER_END_CRITERIA = "entered_end";

    @Inject
    public MVNPPlayerListener(@NotNull MultiverseNetherPortals plugin, @NotNull MVNameChecker nameChecker, @NotNull MVLinkChecker linkChecker, @NotNull WorldManager worldManager, @NotNull EndPlatformCreator endPlatformCreator) {
        this.plugin = plugin;
        this.nameChecker = nameChecker;
        this.linkChecker = linkChecker;
        this.worldManager = worldManager;
        this.endPlatformCreator = endPlatformCreator;
        this.enterNetherAdvancement = this.tryGetAdvancement("story/enter_the_nether");
        this.enterEndAdvancement = this.tryGetAdvancement("story/enter_the_end");
    }

    private Advancement tryGetAdvancement(String advancementName) {
        return (Advancement)Try.of((CheckedFunction0 & Serializable)() -> this.plugin.getServer().getAdvancement(NamespacedKey.minecraft((String)advancementName))).recover(e -> null).getOrNull();
    }

    @EventMethod
    public void onPlayerPortal(PlayerPortalEvent event) {
        PortalType type;
        if (event.isCancelled()) {
            MVPLogging.finest("PlayerPortalEvent was cancelled! NOT teleporting!", new Object[0]);
            return;
        }
        Location currentLocation = event.getFrom().clone();
        if (!this.plugin.isHandledByNetherPortals(currentLocation)) {
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL) {
            type = PortalType.ENDER;
        } else if (event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            type = PortalType.NETHER;
        } else {
            return;
        }
        Player player = event.getPlayer();
        String currentWorld = currentLocation.getWorld().getName();
        String linkedWorld = this.plugin.getWorldLink(currentWorld, type);
        Location newTo = currentWorld.equalsIgnoreCase(linkedWorld) ? null : (linkedWorld != null ? this.linkChecker.findNewTeleportLocation(currentLocation, linkedWorld, (Entity)player) : (this.nameChecker.isValidNetherName(currentWorld) ? (type == PortalType.NETHER ? this.linkChecker.findNewTeleportLocation(currentLocation, this.nameChecker.getNormalName(currentWorld, PortalType.NETHER), (Entity)player) : this.linkChecker.findNewTeleportLocation(currentLocation, this.nameChecker.getEndName(this.nameChecker.getNormalName(currentWorld, PortalType.NETHER)), (Entity)player)) : (this.nameChecker.isValidEndName(currentWorld) ? (type == PortalType.NETHER ? this.linkChecker.findNewTeleportLocation(currentLocation, this.nameChecker.getNetherName(this.nameChecker.getNormalName(currentWorld, PortalType.ENDER)), (Entity)player) : this.linkChecker.findNewTeleportLocation(currentLocation, this.nameChecker.getNormalName(currentWorld, PortalType.ENDER), (Entity)player)) : (type == PortalType.ENDER ? this.linkChecker.findNewTeleportLocation(currentLocation, this.nameChecker.getEndName(currentWorld), (Entity)player) : this.linkChecker.findNewTeleportLocation(currentLocation, this.nameChecker.getNetherName(currentWorld), (Entity)player)))));
        if (newTo == null) {
            event.setCancelled(true);
            return;
        }
        event.setTo(newTo);
        LoadedMultiverseWorld fromWorld = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(event.getFrom().getWorld()).getOrNull();
        LoadedMultiverseWorld toWorld = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(event.getTo().getWorld()).getOrNull();
        if (!event.isCancelled()) {
            if (fromWorld.getEnvironment() == World.Environment.THE_END && type == PortalType.ENDER) {
                MVPLogging.fine("Player '" + player.getName() + "' will be teleported to the spawn of '" + toWorld.getName() + "' since they used an end exit portal.", new Object[0]);
                event.setCanCreatePortal(false);
                if (toWorld.getBedRespawn() && player.getBedSpawnLocation() != null && toWorld.getUID().equals(player.getBedSpawnLocation().getWorld().getUID())) {
                    event.setTo(player.getBedSpawnLocation());
                } else {
                    event.setTo(toWorld.getSpawnLocation());
                }
            } else if (fromWorld.getEnvironment() == World.Environment.NETHER && type == PortalType.NETHER) {
                event.setCanCreatePortal(true);
            } else if (toWorld.getEnvironment() == World.Environment.THE_END && type == PortalType.ENDER) {
                Location spawnLocation = this.endPlatformCreator.getVanillaLocation((Entity)player, event.getTo().getWorld());
                event.setTo(spawnLocation);
                this.endPlatformCreator.createEndPlatform(spawnLocation.getWorld(), this.plugin.isEndPlatformDropBlocks());
            }
            if (type == PortalType.NETHER && event.getTo().getWorld().getEnvironment() == World.Environment.NETHER && this.enterNetherAdvancement != null) {
                this.awardAdvancement(player, this.enterNetherAdvancement, ENTER_NETHER_CRITERIA);
            } else if (type == PortalType.ENDER && event.getTo().getWorld().getEnvironment() == World.Environment.THE_END && this.enterEndAdvancement != null) {
                this.awardAdvancement(player, this.enterEndAdvancement, ENTER_END_CRITERIA);
            }
        }
    }

    private void awardAdvancement(Player player, Advancement advancement, String criteria) {
        if (advancement == null) {
            MVPLogging.fine("No advancement found for target criteria: %s", criteria);
            return;
        }
        AdvancementProgress advancementProgress = player.getAdvancementProgress(advancement);
        if (advancementProgress.isDone()) {
            MVPLogging.fine("%s has already been awarded advancement criteria %s.", player.getName(), criteria);
            return;
        }
        if (!advancementProgress.awardCriteria(criteria)) {
            MVPLogging.warning("Unable to award advancement criteria %s to %s.", criteria, player.getName());
            return;
        }
        MVPLogging.fine("Awarded advancement criteria %s to %s.", criteria, player.getName());
    }
}

