/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals.listeners;

import io.papermc.paper.event.entity.EntityPortalReadyEvent;
import org.bukkit.Bukkit;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.dynamiclistener.EventRunnable;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventClass;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.netherportals.MultiverseNetherPortals;
import org.mvplugins.multiverse.netherportals.listeners.MVNPListener;
import org.mvplugins.multiverse.netherportals.util.MVPLogging;
import org.mvplugins.multiverse.netherportals.utils.MVNameChecker;

@Service
final class MVNPEntityPortalReadyListener
implements MVNPListener {
    private final MultiverseNetherPortals plugin;
    private final MVNameChecker nameChecker;

    @Inject
    MVNPEntityPortalReadyListener(@NotNull MultiverseNetherPortals plugin, @NotNull MVNameChecker nameChecker) {
        this.plugin = plugin;
        this.nameChecker = nameChecker;
    }

    @EventClass(value="io.papermc.paper.event.entity.EntityPortalReadyEvent")
    private EventRunnable entityPortalReadyEvent() {
        return new EventRunnable<EntityPortalReadyEvent>(){

            public void onEvent(EntityPortalReadyEvent event) {
                String fromWorld = event.getEntity().getWorld().getName();
                String linkedWorld = MVNPEntityPortalReadyListener.this.getLinkedWorld(fromWorld, event.getPortalType());
                if (linkedWorld == null) {
                    MVPLogging.fine("No linked world found for world '%s'", fromWorld);
                    return;
                }
                World bukkitLinkedWorld = Bukkit.getWorld((String)linkedWorld);
                if (bukkitLinkedWorld == null) {
                    MVPLogging.fine("Target linked world '%s' not a loaded bukkit world.", linkedWorld);
                    return;
                }
                MVPLogging.fine("Found linked world '%s' for world '%s'", linkedWorld, fromWorld);
                event.setTargetWorld(bukkitLinkedWorld);
            }
        };
    }

    private String getLinkedWorld(String currentWorld, PortalType type) {
        String linkedWorld = this.plugin.getWorldLink(currentWorld, type);
        if (linkedWorld != null) {
            MVPLogging.finer("Got manually linked world '%s' for world '%s'", linkedWorld, currentWorld);
            return linkedWorld;
        }
        if (this.nameChecker.isValidEndName(currentWorld)) {
            if (type == PortalType.ENDER) {
                return this.nameChecker.getNormalName(currentWorld, type);
            }
            if (type == PortalType.NETHER) {
                return this.nameChecker.getNetherName(this.nameChecker.getNormalName(currentWorld, type));
            }
        } else if (this.nameChecker.isValidNetherName(currentWorld)) {
            if (type == PortalType.ENDER) {
                return this.nameChecker.getEndName(this.nameChecker.getNormalName(currentWorld, type));
            }
            if (type == PortalType.NETHER) {
                return this.nameChecker.getNormalName(currentWorld, type);
            }
        } else {
            if (type == PortalType.ENDER) {
                return this.nameChecker.getEndName(currentWorld);
            }
            if (type == PortalType.NETHER) {
                return this.nameChecker.getNetherName(currentWorld);
            }
        }
        return null;
    }
}

