/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals.listeners;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.PortalType;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityPortalExitEvent;
import org.bukkit.util.Vector;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.DefaultEventPriority;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.event.MVPlayerTouchedPortalEvent;
import org.mvplugins.multiverse.core.teleportation.LocationManipulation;
import org.mvplugins.multiverse.core.world.LoadedMultiverseWorld;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.core.world.entrycheck.WorldEntryCheckerProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.netherportals.MultiverseNetherPortals;
import org.mvplugins.multiverse.netherportals.listeners.MVNPListener;
import org.mvplugins.multiverse.netherportals.util.MVPLogging;
import org.mvplugins.multiverse.netherportals.utils.EndPlatformCreator;
import org.mvplugins.multiverse.netherportals.utils.MVEventRecord;
import org.mvplugins.multiverse.netherportals.utils.MVLinkChecker;
import org.mvplugins.multiverse.netherportals.utils.MVNameChecker;

@Service
final class MVNPEntityListener
implements MVNPListener {
    private static final int COOLDOWN = 250;
    private final Map<String, Date> playerErrors = new HashMap<String, Date>();
    private final MultiverseNetherPortals plugin;
    private final MVNameChecker nameChecker;
    private final MVLinkChecker linkChecker;
    private final WorldEntryCheckerProvider entryCheckerProvider;
    private final WorldManager worldManager;
    private final LocationManipulation locationManipulation;
    private final MVEventRecord eventRecord;
    private final EndPlatformCreator endPlatformCreator;

    @Inject
    MVNPEntityListener(@NotNull MultiverseNetherPortals plugin, @NotNull MVNameChecker nameChecker, @NotNull MVLinkChecker linkChecker, @NotNull WorldEntryCheckerProvider entryCheckerProvider, @NotNull WorldManager worldManager, @NotNull LocationManipulation locationManipulation, @NotNull MVEventRecord eventRecord, @NotNull EndPlatformCreator endPlatformCreator) {
        this.plugin = plugin;
        this.nameChecker = nameChecker;
        this.linkChecker = linkChecker;
        this.entryCheckerProvider = entryCheckerProvider;
        this.worldManager = worldManager;
        this.locationManipulation = locationManipulation;
        this.eventRecord = eventRecord;
        this.endPlatformCreator = endPlatformCreator;
    }

    private boolean shootPlayer(Player p, Block block, PortalType type) {
        if (!this.plugin.isUsingBounceBack()) {
            MVPLogging.finest("Bounceback is disabled. The player is free to walk into the portal!", new Object[0]);
            return false;
        }
        this.playerErrors.put(p.getName(), new Date());
        double newVecX = 0.0;
        double newVecZ = 0.0;
        double strength = 1.0;
        boolean playerBounced = false;
        StringBuilder debugMessage = new StringBuilder().append("Player: ").append(p.getName());
        if (type == PortalType.ENDER) {
            debugMessage.append(" entered an End Portal. There is currently no bounceback implementation for End Portals.");
        } else if (type == PortalType.NETHER) {
            if (block.getRelative(BlockFace.WEST).getType() == Material.NETHER_PORTAL || block.getRelative(BlockFace.EAST).getType() == Material.NETHER_PORTAL) {
                if (p.getLocation().getZ() < block.getLocation().getZ() + 0.5) {
                    debugMessage.append(" entered Nether Portal from the North");
                    newVecZ = -1.0 * strength;
                } else {
                    debugMessage.append(" entered Nether Portal from the South");
                    newVecZ = 1.0 * strength;
                }
            } else if (p.getLocation().getX() < block.getLocation().getX() + 0.5) {
                debugMessage.append(" entered Nether Portal from the West");
                newVecX = -1.0 * strength;
            } else {
                debugMessage.append(" entered Nether Portal from the East");
                newVecX = 1.0 * strength;
            }
            debugMessage.append(". They will be bounced back!");
            p.teleport(p.getLocation().clone().add(newVecX, 0.2, newVecZ));
            p.setVelocity(new Vector(newVecX, 0.6, newVecZ));
            playerBounced = true;
        } else {
            debugMessage.append(" entered an Unsupported Portal Type (").append(type).append(").");
        }
        MVPLogging.finer(debugMessage.toString(), new Object[0]);
        return playerBounced;
    }

    @Nullable
    private Location getLocation(Entity e, Location currentLocation, PortalType type, String currentWorld, String linkedWorld) {
        Location newTo = null;
        if (!currentWorld.equalsIgnoreCase(linkedWorld)) {
            if (linkedWorld != null) {
                newTo = this.linkChecker.findNewTeleportLocation(currentLocation, linkedWorld, e);
            } else {
                String destinationWorld = "";
                if (this.nameChecker.isValidEndName(currentWorld)) {
                    if (type == PortalType.ENDER) {
                        destinationWorld = this.nameChecker.getNormalName(currentWorld, type);
                    } else if (type == PortalType.NETHER) {
                        destinationWorld = this.nameChecker.getNetherName(this.nameChecker.getNormalName(currentWorld, type));
                    }
                } else if (this.nameChecker.isValidNetherName(currentWorld)) {
                    if (type == PortalType.ENDER) {
                        destinationWorld = this.nameChecker.getEndName(this.nameChecker.getNormalName(currentWorld, type));
                    } else if (type == PortalType.NETHER) {
                        destinationWorld = this.nameChecker.getNormalName(currentWorld, type);
                    }
                } else if (type == PortalType.ENDER) {
                    destinationWorld = this.nameChecker.getEndName(currentWorld);
                } else if (type == PortalType.NETHER) {
                    destinationWorld = this.nameChecker.getNetherName(currentWorld);
                }
                newTo = this.linkChecker.findNewTeleportLocation(currentLocation, destinationWorld, e);
            }
        }
        return newTo;
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.MONITOR)
    public void onEntityPortalEnter(EntityPortalEnterEvent event) {
        String linkedWorld;
        String currentWorld;
        Location toLocation;
        PortalType type;
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getEntity();
        Location currentLocation = this.locationManipulation.getBlockLocation(event.getLocation());
        if (!this.plugin.isHandledByNetherPortals(currentLocation)) {
            return;
        }
        if (currentLocation.getBlock().getType() == Material.END_PORTAL) {
            type = PortalType.ENDER;
        } else if (currentLocation.getBlock().getType() == Material.NETHER_PORTAL) {
            type = PortalType.NETHER;
        } else {
            return;
        }
        if (this.eventRecord.isInRecord(type, p.getUniqueId())) {
            return;
        }
        this.eventRecord.addToRecord(type, p.getUniqueId());
        MVPlayerTouchedPortalEvent playerTouchedPortalEvent = new MVPlayerTouchedPortalEvent(p, event.getLocation());
        this.plugin.getServer().getPluginManager().callEvent((Event)playerTouchedPortalEvent);
        Location eventLocation = event.getLocation().clone();
        if (!playerTouchedPortalEvent.canUseThisPortal()) {
            if (this.shootPlayer(p, eventLocation.getBlock(), type)) {
                this.eventRecord.removeFromRecord(type, p.getUniqueId());
            }
            MVPLogging.finest("Someone requested that this player be bounced back!", new Object[0]);
        }
        if (playerTouchedPortalEvent.isCancelled()) {
            MVPLogging.finest("Someone cancelled the enter Event for NetherPortals!", new Object[0]);
            return;
        }
        if (this.playerErrors.containsKey(p.getName())) {
            Date lastTry = this.playerErrors.get(p.getName());
            if (lastTry.getTime() + 250L > new Date().getTime()) {
                return;
            }
            this.playerErrors.remove(p.getName());
        }
        if ((toLocation = this.getLocation((Entity)p, currentLocation, type, currentWorld = currentLocation.getWorld().getName(), linkedWorld = this.plugin.getWorldLink(currentWorld, type))) == null) {
            if (this.shootPlayer(p, eventLocation.getBlock(), type)) {
                this.eventRecord.removeFromRecord(type, p.getUniqueId());
            }
            if (currentWorld.equalsIgnoreCase(linkedWorld)) {
                if (this.plugin.isSendingDisabledPortalMessage()) {
                    if (type == PortalType.ENDER) {
                        p.sendMessage("End Portals have been disabled in this world!");
                    } else {
                        p.sendMessage("Nether Portals have been disabled in this world!");
                    }
                }
            } else if (this.plugin.isSendingNoDestinationMessage()) {
                p.sendMessage("This portal goes nowhere!");
                if (type == PortalType.ENDER) {
                    p.sendMessage("No specific end world has been linked to this world and '" + this.nameChecker.getEndName(currentWorld) + "' is not a world.");
                } else {
                    p.sendMessage("No specific nether world has been linked to this world and '" + this.nameChecker.getNetherName(currentWorld) + "' is not a world.");
                }
            }
            return;
        }
        LoadedMultiverseWorld fromWorld = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(p.getLocation().getWorld()).getOrNull();
        LoadedMultiverseWorld toWorld = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(toLocation.getWorld()).getOrNull();
        if (fromWorld.getBukkitWorld().eq((Object)toWorld.getBukkitWorld())) {
            MVPLogging.finer("Player '" + p.getName() + "' is portaling to the same world.", new Object[0]);
            return;
        }
        this.entryCheckerProvider.forSender((CommandSender)p).canEnterWorld((MultiverseWorld)fromWorld, toWorld).onSuccess(result -> MVPLogging.fine("Player '" + p.getName() + "' was ALLOWED ACCESS to '" + toWorld.getName() + "': " + String.valueOf(result), new Object[0])).onFailure(result -> {
            if (this.shootPlayer(p, eventLocation.getBlock(), type)) {
                this.eventRecord.removeFromRecord(type, p.getUniqueId());
            }
            MVPLogging.fine("Player '" + p.getName() + "' was DENIED ACCESS to '" + toWorld.getName() + "': " + String.valueOf(result), new Object[0]);
        });
    }

    @EventMethod
    public void onEntityPortal(EntityPortalEvent event) {
        PortalType type;
        if (event.isCancelled()) {
            MVPLogging.finest("EntityPortalEvent was cancelled! NOT teleporting!", new Object[0]);
            return;
        }
        if (event.getTo() == null) {
            MVPLogging.warning("getTo() location in EntityPortalEvent is null.", new Object[0]);
            return;
        }
        if (!this.plugin.isHandledByNetherPortals(event.getFrom())) {
            return;
        }
        if (!this.plugin.isTeleportingEntities()) {
            event.setCancelled(true);
            return;
        }
        Entity entity = event.getEntity();
        Location fromLocation = event.getFrom();
        Location originalToLocation = event.getTo();
        World fromWorld = fromLocation.getWorld();
        World originalToWorld = originalToLocation.getWorld();
        if (fromWorld == null || originalToWorld == null) {
            MVPLogging.warning("from/to world is null in EntityPortalEvent for %s", entity.getName());
            return;
        }
        if (originalToWorld.getEnvironment() == World.Environment.NETHER || fromWorld.getEnvironment() == World.Environment.NETHER && originalToWorld.getEnvironment() == World.Environment.NORMAL) {
            type = PortalType.NETHER;
        } else if (originalToWorld.getEnvironment() == World.Environment.THE_END || fromWorld.getEnvironment() == World.Environment.THE_END && originalToWorld.getEnvironment() == World.Environment.NORMAL) {
            type = PortalType.ENDER;
        } else {
            return;
        }
        String fromWorldName = fromWorld.getName();
        String linkedWorldName = this.plugin.getWorldLink(fromWorldName, type);
        Location newToLocation = this.getLocation(entity, fromLocation, type, fromWorldName, linkedWorldName);
        if (newToLocation == null) {
            event.setCancelled(true);
            return;
        }
        event.setTo(newToLocation);
        LoadedMultiverseWorld newToWorld = (LoadedMultiverseWorld)this.worldManager.getLoadedWorld(newToLocation.getWorld()).getOrNull();
        if (fromWorld.getEnvironment() == World.Environment.THE_END && type == PortalType.ENDER) {
            event.setTo(newToWorld.getSpawnLocation());
        } else if (newToWorld.getEnvironment() == World.Environment.THE_END && type == PortalType.ENDER) {
            Location spawnLocation = this.endPlatformCreator.getVanillaLocation(entity, newToWorld);
            event.setTo(spawnLocation);
            this.endPlatformCreator.createEndPlatform(spawnLocation.getWorld(), this.plugin.isEndPlatformDropBlocks());
        }
    }

    @EventMethod
    public void onEntityPortalExit(EntityPortalExitEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            this.eventRecord.removeFromRecord(PortalType.ENDER, player.getUniqueId());
            this.eventRecord.removeFromRecord(PortalType.NETHER, player.getUniqueId());
        }
    }
}

