/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals.listeners;

import java.io.File;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.core.event.MVConfigReloadEvent;
import org.mvplugins.multiverse.core.event.MVDebugModeEvent;
import org.mvplugins.multiverse.core.event.MVDumpsDebugInfoEvent;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.netherportals.MultiverseNetherPortals;
import org.mvplugins.multiverse.netherportals.listeners.MVNPListener;
import org.mvplugins.multiverse.netherportals.util.MVPLogging;

@Service
final class MVNPCoreListener
implements MVNPListener {
    private final MultiverseNetherPortals plugin;

    @Inject
    MVNPCoreListener(MultiverseNetherPortals plugin) {
        this.plugin = plugin;
    }

    @EventMethod
    public void configReloadEvent(MVConfigReloadEvent event) {
        this.plugin.loadConfig();
        event.addConfig("Multiverse-NetherPortals - config.yml");
    }

    @EventMethod
    public void versionEvent(MVDumpsDebugInfoEvent event) {
        event.appendDebugInfo(this.plugin.getDebugInfo());
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        event.putDetailedDebugInfo("multiverse-netherportals/config.yml", configFile);
    }

    @EventMethod
    public void debugModeChange(MVDebugModeEvent event) {
        MVPLogging.setDebugLevel(event.getLevel());
    }
}

