/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals.commands;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.PortalType;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.display.ContentDisplay;
import org.mvplugins.multiverse.core.display.handlers.PagedSendHandler;
import org.mvplugins.multiverse.core.display.handlers.SendHandler;
import org.mvplugins.multiverse.core.display.parsers.ContentProvider;
import org.mvplugins.multiverse.core.display.parsers.ListContentProvider;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.commands.annotation.Values;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.netherportals.MultiverseNetherPortals;
import org.mvplugins.multiverse.netherportals.commands.NetherPortalsCommand;

@Service
class ListCommand
extends NetherPortalsCommand {
    private final MultiverseNetherPortals plugin;
    private final WorldManager worldManager;

    @Inject
    ListCommand(@NotNull MultiverseNetherPortals plugin, @NotNull WorldManager worldManager) {
        this.plugin = plugin;
        this.worldManager = worldManager;
    }

    @Subcommand(value="list")
    @CommandPermission(value="multiverse.netherportals.show")
    @CommandCompletion(value="nether|end")
    @Syntax(value="[nether|end]")
    @Description(value="Displays a nicely formatted list of all portal links.")
    void onListCommand(@NotNull MVCommandIssuer issuer, @Optional @Values(value="nether|end") @Syntax(value="<nether|end>") @Description(value="Portal type to list.") @Nullable String linkTypeString) {
        PortalType linkType = null;
        if (linkTypeString != null && !linkTypeString.isEmpty()) {
            if (linkTypeString.equalsIgnoreCase("nether")) {
                linkType = PortalType.NETHER;
            } else if (linkTypeString.equalsIgnoreCase("end")) {
                linkType = PortalType.ENDER;
            }
        }
        String linkString = this.parseTypeString(linkType);
        ContentDisplay.create().addContent((ContentProvider)ListContentProvider.forContent(this.buildLinkContent(linkType))).withSendHandler((SendHandler)((PagedSendHandler)((PagedSendHandler)PagedSendHandler.create().withHeader(String.format("%s==== [ %s %sPortal Links ] ====", ChatColor.DARK_PURPLE, linkString, ChatColor.DARK_PURPLE), new Object[0])).noContentMessage(String.format("%sNo %s %slinks found.", ChatColor.WHITE, linkString, ChatColor.WHITE))).doPagination(false)).send(issuer);
    }

    private String parseTypeString(@Nullable PortalType linkType) {
        if (linkType == null) {
            return "All";
        }
        return switch (linkType) {
            case PortalType.NETHER -> String.valueOf(ChatColor.RED) + "Nether";
            case PortalType.ENDER -> String.valueOf(ChatColor.AQUA) + "End";
            default -> "All";
        };
    }

    private List<String> buildLinkContent(@Nullable PortalType linkType) {
        return linkType == null ? this.getAllLinksContent() : this.buildLinkContent(linkType, "");
    }

    private List<String> getAllLinksContent() {
        List<String> contents = this.buildLinkContent(PortalType.NETHER, String.valueOf(ChatColor.DARK_RED) + "[" + String.valueOf(ChatColor.RED) + "Nether" + String.valueOf(ChatColor.DARK_RED) + "] ");
        contents.addAll(this.buildLinkContent(PortalType.ENDER, String.valueOf(ChatColor.DARK_AQUA) + "[" + String.valueOf(ChatColor.AQUA) + "End" + String.valueOf(ChatColor.DARK_AQUA) + "] "));
        return contents;
    }

    private List<String> buildLinkContent(@NotNull PortalType linkType, @NotNull String prefix) {
        Map<String, String> links = linkType == PortalType.NETHER ? this.plugin.getWorldLinks() : this.plugin.getEndWorldLinks();
        return links.entrySet().stream().map(link -> this.parseSingleLink((String)link.getKey(), (String)link.getValue(), prefix)).collect(Collectors.toList());
    }

    private String parseSingleLink(@NotNull String fromWorldString, @NotNull String toWorldString, @NotNull String prefix) {
        return prefix + String.valueOf(ChatColor.WHITE) + this.ParseWorldString(fromWorldString) + String.valueOf(ChatColor.WHITE) + " -> " + this.ParseWorldString(toWorldString);
    }

    private String ParseWorldString(@NotNull String worldName) {
        return (String)this.worldManager.getLoadedWorld(worldName).map(MultiverseWorld::getAliasOrName).getOrElse((Object)(String.valueOf(ChatColor.GRAY) + worldName + String.valueOf(ChatColor.RED) + " !!ERROR!!"));
    }

    @Service
    private static final class LegacyAlias
    extends ListCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(MultiverseNetherPortals plugin, WorldManager worldManager) {
            super(plugin, worldManager);
        }

        @Override
        @CommandAlias(value="mvnplist|mvnpli")
        void onListCommand(MVCommandIssuer issuer, String linkTypeString) {
            super.onListCommand(issuer, linkTypeString);
        }
    }
}

