/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.netherportals;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.module.MultiverseModule;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jakarta.inject.Provider;
import org.mvplugins.multiverse.netherportals.MultiverseNetherPortalsPluginBinder;
import org.mvplugins.multiverse.netherportals.commands.NetherPortalsCommand;
import org.mvplugins.multiverse.netherportals.listeners.MVNPListener;
import org.mvplugins.multiverse.netherportals.util.MVPLogging;
import org.mvplugins.multiverse.portals.MultiversePortalsApi;
import org.mvplugins.multiverse.portals.utils.PortalManager;

public class MultiverseNetherPortals
extends MultiverseModule {
    private static final double TARGET_CORE_API_VERSION = 5.0;
    private static final String NETHER_PORTALS_CONFIG = "config.yml";
    private static final String DEFAULT_NETHER_PREFIX = "";
    private static final String DEFAULT_NETHER_SUFFIX = "_nether";
    private static final String DEFAULT_END_PREFIX = "";
    private static final String DEFAULT_END_SUFFIX = "_the_end";
    private Plugin multiversePortals;
    private FileConfiguration MVNPConfiguration;
    private Map<String, String> linkMap;
    private Map<String, String> endLinkMap;
    @Inject
    private Provider<CoreConfig> coreConfig;
    @Inject
    private Provider<MVCommandManager> commandManager;

    public void onLoad() {
        super.onLoad();
        MVPLogging.init((Plugin)this);
        this.getDataFolder().mkdirs();
    }

    public void onEnable() {
        super.onEnable();
        this.multiversePortals = this.getServer().getPluginManager().getPlugin("Multiverse-Portals");
        this.initializeDependencyInjection(new MultiverseNetherPortalsPluginBinder(this));
        MVPLogging.setDebugLevel(((CoreConfig)this.coreConfig.get()).getGlobalDebug());
        this.loadConfig();
        this.registerCommands(NetherPortalsCommand.class);
        this.registerDynamicListeners(MVNPListener.class);
        MVPLogging.config("Version %s (API v%s) Enabled - By %s", this.getDescription().getVersion(), this.getVersionAsNumber(), StringFormatter.joinAnd((List)this.getDescription().getAuthors()));
    }

    public void loadConfig() {
        Set worldKeys;
        this.initMVNPConfig();
        this.linkMap = new HashMap<String, String>();
        this.endLinkMap = new HashMap<String, String>();
        this.setUsingBounceBack(this.isUsingBounceBack());
        this.setTeleportingEntities(this.isTeleportingEntities());
        this.setSendingNoDestinationMessage(this.isSendingNoDestinationMessage());
        this.setSendingDisabledPortalMessage(this.isSendingDisabledPortalMessage());
        this.setEndPlatformDropBlocks(this.isEndPlatformDropBlocks());
        this.setNetherPrefix(this.getNetherPrefix());
        this.setNetherSuffix(this.getNetherSuffix());
        this.setEndPrefix(this.getEndPrefix());
        this.setEndSuffix(this.getEndSuffix());
        if (this.MVNPConfiguration.getConfigurationSection("worlds") == null) {
            this.MVNPConfiguration.createSection("worlds");
        }
        if ((worldKeys = this.MVNPConfiguration.getConfigurationSection("worlds").getKeys(false)) != null) {
            for (String worldString : worldKeys) {
                String oldEnder;
                String nether = this.MVNPConfiguration.getString("worlds." + worldString + ".portalgoesto." + String.valueOf(PortalType.NETHER), null);
                String ender = this.MVNPConfiguration.getString("worlds." + worldString + ".portalgoesto." + String.valueOf(PortalType.ENDER), null);
                if (nether != null) {
                    this.linkMap.put(worldString, nether);
                }
                if (ender != null) {
                    this.endLinkMap.put(worldString, ender);
                }
                if ((oldEnder = this.MVNPConfiguration.getString("worlds." + worldString + ".portalgoesto.END", null)) == null) continue;
                if (this.addWorldLink(worldString, oldEnder, PortalType.ENDER)) {
                    this.MVNPConfiguration.set("worlds." + worldString + ".portalgoesto.END", null);
                    continue;
                }
                MVPLogging.warning("Error converting old end link of '%s' to '%s'", worldString, oldEnder);
            }
        }
        this.saveMVNPConfig();
    }

    private void initMVNPConfig() {
        this.MVNPConfiguration = new YamlConfiguration();
        try {
            File configFile = new File(this.getDataFolder(), NETHER_PORTALS_CONFIG);
            if (!configFile.isFile()) {
                MVPLogging.info("Creating new %s", NETHER_PORTALS_CONFIG);
                configFile.createNewFile();
            }
            this.MVNPConfiguration.load(configFile);
        }
        catch (IOException e) {
            MVPLogging.severe("Could not load config.yml", new Object[0]);
        }
        catch (InvalidConfigurationException e) {
            MVPLogging.severe("config.yml contained INVALID YAML. Please look at the file.", new Object[0]);
        }
    }

    public void onDisable() {
        this.shutdownDependencyInjection();
        MVPLogging.info("- Disabled", new Object[0]);
        MVPLogging.shutdown();
    }

    public double getTargetCoreVersion() {
        return 5.0;
    }

    @NotNull
    public Logger getLogger() {
        return MVPLogging.getLogger();
    }

    public void setNetherPrefix(String netherPrefix) {
        this.MVNPConfiguration.set("portal-auto-link-when.nether.prefix", (Object)netherPrefix);
    }

    public String getNetherPrefix() {
        return this.MVNPConfiguration.getString("portal-auto-link-when.nether.prefix", "");
    }

    public void setNetherSuffix(String netherSuffix) {
        this.MVNPConfiguration.set("portal-auto-link-when.nether.suffix", (Object)netherSuffix);
    }

    public String getNetherSuffix() {
        return this.MVNPConfiguration.getString("portal-auto-link-when.nether.suffix", DEFAULT_NETHER_SUFFIX);
    }

    public void setEndPrefix(String endPrefix) {
        this.MVNPConfiguration.set("portal-auto-link-when.end.prefix", (Object)endPrefix);
    }

    public String getEndPrefix() {
        return this.MVNPConfiguration.getString("portal-auto-link-when.end.prefix", "");
    }

    public void setEndSuffix(String endSuffix) {
        this.MVNPConfiguration.set("portal-auto-link-when.end.suffix", (Object)endSuffix);
    }

    public String getEndSuffix() {
        return this.MVNPConfiguration.getString("portal-auto-link-when.end.suffix", DEFAULT_END_SUFFIX);
    }

    public String getWorldLink(String fromWorld, PortalType type) {
        if (type == PortalType.NETHER) {
            return this.linkMap.get(fromWorld);
        }
        if (type == PortalType.ENDER) {
            return this.endLinkMap.get(fromWorld);
        }
        return null;
    }

    public Map<String, String> getWorldLinks() {
        return this.linkMap;
    }

    public Map<String, String> getEndWorldLinks() {
        return this.endLinkMap;
    }

    public boolean addWorldLink(String from, String to, PortalType type) {
        if (type == PortalType.NETHER) {
            this.linkMap.put(from, to);
        } else if (type == PortalType.ENDER) {
            this.endLinkMap.put(from, to);
        } else {
            return false;
        }
        this.MVNPConfiguration.set("worlds." + from + ".portalgoesto." + String.valueOf(type), (Object)to);
        this.saveMVNPConfig();
        return true;
    }

    public boolean removeWorldLink(String from, String to, PortalType type) {
        if (type == PortalType.NETHER) {
            this.linkMap.remove(from);
        } else if (type == PortalType.ENDER) {
            this.endLinkMap.remove(from);
        } else {
            return false;
        }
        this.MVNPConfiguration.set("worlds." + from + ".portalgoesto." + String.valueOf(type), null);
        return this.saveMVNPConfig();
    }

    public boolean saveMVNPConfig() {
        try {
            this.MVNPConfiguration.save(new File(this.getDataFolder(), NETHER_PORTALS_CONFIG));
            return true;
        }
        catch (IOException e) {
            MVPLogging.severe("Could not save config.yml", new Object[0]);
            return false;
        }
    }

    public boolean isUsingBounceBack() {
        return this.MVNPConfiguration.getBoolean("bounceback", true);
    }

    public void setUsingBounceBack(boolean useBounceBack) {
        this.MVNPConfiguration.set("bounceback", (Object)useBounceBack);
    }

    public boolean isTeleportingEntities() {
        return this.MVNPConfiguration.getBoolean("teleport_entities", true);
    }

    public void setTeleportingEntities(boolean teleportingEntities) {
        this.MVNPConfiguration.set("teleport_entities", (Object)teleportingEntities);
    }

    public boolean isSendingDisabledPortalMessage() {
        return this.MVNPConfiguration.getBoolean("send_disabled_portal_message", true);
    }

    public void setSendingDisabledPortalMessage(boolean sendDisabledPortalMessage) {
        this.MVNPConfiguration.set("send_disabled_portal_message", (Object)sendDisabledPortalMessage);
    }

    public boolean isSendingNoDestinationMessage() {
        return this.MVNPConfiguration.getBoolean("send_no_destination_message", true);
    }

    public void setSendingNoDestinationMessage(boolean sendNoDestinationMessage) {
        this.MVNPConfiguration.set("send_no_destination_message", (Object)sendNoDestinationMessage);
    }

    public boolean isEndPlatformDropBlocks() {
        return this.MVNPConfiguration.getBoolean("end_platform_drop_blocks", true);
    }

    public void setEndPlatformDropBlocks(boolean endPlatformDropBlocks) {
        this.MVNPConfiguration.set("end_platform_drop_blocks", (Object)endPlatformDropBlocks);
    }

    public boolean isHandledByNetherPortals(Location l) {
        if (this.multiversePortals != null) {
            try {
                PortalManager portalManager = MultiversePortalsApi.get().getPortalManager();
                if (portalManager.isPortal(l)) {
                    return false;
                }
            }
            catch (Throwable t) {
                this.getLogger().log(Level.WARNING, "Error checking if portal is handled by Multiverse-Portals", t);
            }
        }
        return true;
    }

    @ApiStatus.Internal
    public void setPortals(Plugin multiversePortals) {
        this.multiversePortals = multiversePortals;
    }

    public String getDebugInfo() {
        return "[Multiverse-NetherPortals] Multiverse-NetherPortals Version: " + this.getDescription().getVersion() + "\n[Multiverse-NetherPortals] Nether Prefix: " + this.getNetherPrefix() + "\n[Multiverse-NetherPortals] Nether Suffix: " + this.getNetherSuffix() + "\n[Multiverse-NetherPortals] End Prefix: " + this.getEndPrefix() + "\n[Multiverse-NetherPortals] End Suffix: " + this.getEndSuffix() + "\n[Multiverse-NetherPortals] Nether Links: " + String.valueOf(this.getWorldLinks()) + "\n[Multiverse-NetherPortals] End Links: " + String.valueOf(this.getEndWorldLinks()) + "\n[Multiverse-NetherPortals] Bounceback: " + this.isUsingBounceBack() + "\n[Multiverse-NetherPortals] Teleport Entities: " + this.isTeleportingEntities() + "\n[Multiverse-NetherPortals] Send Disabled Portal Message: " + this.isSendingDisabledPortalMessage() + "\n[Multiverse-NetherPortals] Send No Destination Message: " + this.isSendingNoDestinationMessage() + "\n[Multiverse-NetherPortals] Server Allow Nether: " + this.getServer().getAllowNether() + "\n[Multiverse-NetherPortals] Server Allow End: " + this.getServer().getAllowEnd() + "\n[Multiverse-NetherPortals] Special Code: FRN001\n";
    }
}

