/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.view;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.view.PlayerInventoryData;

@Service
@ApiStatus.Experimental
@ApiStatus.AvailableSince(value="5.2")
public final class InventoryGUIHelper {
    private final NamespacedKey IS_FILLER_KEY;
    private final NamespacedKey IS_DISPLAY_ITEM_KEY;

    @Inject
    InventoryGUIHelper(@NotNull MultiverseInventories inventories) {
        this.IS_FILLER_KEY = new NamespacedKey((Plugin)inventories, "is_mvinv_filler");
        this.IS_DISPLAY_ITEM_KEY = new NamespacedKey((Plugin)inventories, "is_mvinv_display");
    }

    @ApiStatus.AvailableSince(value="5.2")
    public ItemStack createFillerItem(Material material, String name, String lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.GOLD) + name);
            meta.setLore(Collections.singletonList(String.valueOf(ChatColor.GRAY) + lore));
            meta.getPersistentDataContainer().set(this.IS_FILLER_KEY, PersistentDataType.BYTE, (Object)1);
            item.setItemMeta(meta);
        }
        return item;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public boolean isFillerItem(@NotNull ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        PersistentDataContainer persistentDataContainer = item.getItemMeta().getPersistentDataContainer();
        return persistentDataContainer.has(this.IS_FILLER_KEY, PersistentDataType.BYTE) && (Byte)persistentDataContainer.getOrDefault(this.IS_FILLER_KEY, PersistentDataType.BYTE, (Object)0) == 1;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public boolean isDisplayItem(@NotNull ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        return item.getItemMeta().getPersistentDataContainer().has(this.IS_DISPLAY_ITEM_KEY, PersistentDataType.BYTE) && (Byte)item.getItemMeta().getPersistentDataContainer().get(this.IS_DISPLAY_ITEM_KEY, PersistentDataType.BYTE) == 1;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public boolean isValidItemForSlot(@NotNull ItemStack item, int slot) {
        if (item.getType() == Material.AIR) {
            return true;
        }
        if (this.isFillerItem(item)) {
            return true;
        }
        return switch (slot) {
            case 36 -> item.getType().name().endsWith("_HELMET");
            case 37 -> item.getType().name().endsWith("_CHESTPLATE");
            case 38 -> item.getType().name().endsWith("_LEGGINGS");
            case 39 -> item.getType().name().endsWith("_BOOTS");
            case 40 -> true;
            case 41, 42, 43, 44 -> false;
            default -> true;
        };
    }

    @ApiStatus.AvailableSince(value="5.2")
    public ItemStack createFillerItemForSlot(int slot, boolean isModifiable) {
        String helmetLore = isModifiable ? "Place Helmet Here" : "No Helmet";
        String chestplateLore = isModifiable ? "Place Chestplate Here" : "No Chestplate";
        String leggingsLore = isModifiable ? "Place Leggings Here" : "No Leggings";
        String bootsLore = isModifiable ? "Place Boots Here" : "No Boots";
        String offHandLore = isModifiable ? "Place Off-Hand Item Here" : "No Off-Hand Item";
        return switch (slot) {
            case 36 -> this.createFillerItem(Material.GRAY_STAINED_GLASS_PANE, "Helmet Slot", helmetLore);
            case 37 -> this.createFillerItem(Material.GRAY_STAINED_GLASS_PANE, "Chestplate Slot", chestplateLore);
            case 38 -> this.createFillerItem(Material.GRAY_STAINED_GLASS_PANE, "Leggings Slot", leggingsLore);
            case 39 -> this.createFillerItem(Material.GRAY_STAINED_GLASS_PANE, "Boots Slot", bootsLore);
            case 40 -> this.createFillerItem(Material.GRAY_STAINED_GLASS_PANE, "Off-Hand Slot", offHandLore);
            case 41, 42, 43, 44 -> this.createFillerItem(Material.BARRIER, " ", " ");
            default -> new ItemStack(Material.AIR);
        };
    }

    private ItemStack createDisplayItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(String.valueOf(ChatColor.AQUA) + name);
            meta.setLore(lore);
            meta.getPersistentDataContainer().set(this.IS_DISPLAY_ITEM_KEY, PersistentDataType.BYTE, (Object)1);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createHealthDisplayItem(@Nullable Double health, @Nullable Double maxHealth) {
        ArrayList<String> lore = new ArrayList<String>();
        if (health == null) {
            lore.add(String.valueOf(ChatColor.RED) + "N/A (No Data)");
        } else {
            DecimalFormat df = new DecimalFormat("0.0");
            lore.add(String.valueOf(ChatColor.WHITE) + "Current: " + String.valueOf(ChatColor.RED) + df.format(health) + String.valueOf(ChatColor.WHITE) + " / " + String.valueOf(ChatColor.RED) + df.format(maxHealth));
        }
        return this.createDisplayItem(Material.RED_DYE, "Health", lore);
    }

    private ItemStack createLevelDisplayItem(@Nullable Integer level, @Nullable Float exp) {
        ArrayList<String> lore = new ArrayList<String>();
        if (level == null) {
            lore.add(String.valueOf(ChatColor.RED) + "N/A (No Data)");
        } else {
            lore.add(String.valueOf(ChatColor.WHITE) + "Level: " + String.valueOf(ChatColor.GREEN) + level);
            lore.add(String.valueOf(ChatColor.WHITE) + "Progress: " + String.valueOf(ChatColor.AQUA) + String.format("%.1f%%", Float.valueOf(exp.floatValue() * 100.0f)));
        }
        return this.createDisplayItem(Material.EXPERIENCE_BOTTLE, "Experience", lore);
    }

    private ItemStack createFoodDisplayItem(@Nullable Integer foodLevel, @Nullable Float saturation) {
        ArrayList<String> lore = new ArrayList<String>();
        if (foodLevel == null) {
            lore.add(String.valueOf(ChatColor.RED) + "N/A (No Data)");
        }
        lore.add(String.valueOf(ChatColor.WHITE) + "Food: " + String.valueOf(ChatColor.GOLD) + foodLevel + String.valueOf(ChatColor.WHITE) + " / " + String.valueOf(ChatColor.GOLD) + "20");
        lore.add(String.valueOf(ChatColor.WHITE) + "Saturation: " + String.valueOf(ChatColor.LIGHT_PURPLE) + String.format("%.1f", saturation));
        return this.createDisplayItem(Material.COOKED_BEEF, "Food & Saturation", lore);
    }

    private ItemStack createLastLocationDisplayItem(@NotNull String locationString) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(String.valueOf(ChatColor.WHITE) + "Last Location:");
        lore.add(String.valueOf(ChatColor.YELLOW) + locationString);
        return this.createDisplayItem(Material.COMPASS, "Last Location", lore);
    }

    private ItemStack getOrFillItem(ItemStack item, int slot, boolean isModifiable) {
        if (item == null || item.getType() == Material.AIR) {
            return this.createFillerItemForSlot(slot, isModifiable);
        }
        return item;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public void populateInventoryGUI(@NotNull Inventory inv, @NotNull PlayerInventoryData playerInventoryData, boolean isModifiable) {
        if (playerInventoryData.contents != null) {
            for (int i = 0; i < Math.min(playerInventoryData.contents.length, 36); ++i) {
                inv.setItem(i, playerInventoryData.contents[i]);
            }
        }
        inv.setItem(36, this.getOrFillItem(playerInventoryData.armor != null ? playerInventoryData.armor[3] : null, 36, isModifiable));
        inv.setItem(37, this.getOrFillItem(playerInventoryData.armor != null ? playerInventoryData.armor[2] : null, 37, isModifiable));
        inv.setItem(38, this.getOrFillItem(playerInventoryData.armor != null ? playerInventoryData.armor[1] : null, 38, isModifiable));
        inv.setItem(39, this.getOrFillItem(playerInventoryData.armor != null ? playerInventoryData.armor[0] : null, 39, isModifiable));
        inv.setItem(40, this.getOrFillItem(playerInventoryData.offHand, 40, isModifiable));
        inv.setItem(41, this.createHealthDisplayItem(playerInventoryData.health, playerInventoryData.maxHealth));
        inv.setItem(42, this.createFoodDisplayItem(playerInventoryData.foodLevel, playerInventoryData.saturation));
        inv.setItem(43, this.createLevelDisplayItem(playerInventoryData.level, playerInventoryData.exp));
        inv.setItem(44, this.createLastLocationDisplayItem(playerInventoryData.lastLocation));
    }
}

