/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.utils.configuration.json;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.utils.configuration.SerializableSet;
import org.mvplugins.multiverse.inventories.utils.configuration.json.JsonConfigurationOptions;
import org.mvplugins.multiverse.inventories.utils.configuration.util.SerializationHelper;
import org.mvplugins.multiverse.inventories.utils.minidev.json.JSONValue;
import org.mvplugins.multiverse.inventories.utils.minidev.json.parser.JSONParser;
import org.mvplugins.multiverse.inventories.utils.minidev.json.parser.ParseException;

public class JsonConfiguration
extends FileConfiguration {
    protected static final String BLANK_CONFIG = "{}\n";
    private static final Logger LOG = Logger.getLogger(JsonConfiguration.class.getName());

    @NotNull
    public String saveToString() {
        String dump = JSONValue.toJSONString(SerializationHelper.serialize(this.getValues(false)));
        if (dump.equals(BLANK_CONFIG)) {
            dump = "";
        }
        return dump;
    }

    public void loadFromString(@NotNull String contents) throws InvalidConfigurationException {
        Map input;
        if (contents.isEmpty()) {
            return;
        }
        try {
            input = (Map)new JSONParser(528).parse(contents);
        }
        catch (ParseException e) {
            throw new InvalidConfigurationException("Invalid JSON detected.", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("Top level is not a Map.", (Throwable)e);
        }
        if (input == null) {
            throw new InvalidConfigurationException("An unknown error occurred while attempting to parse the json.");
        }
        this.convertMapsToSections(input, (ConfigurationSection)this);
    }

    private void convertMapsToSections(@NotNull Map<?, ?> input, @NotNull ConfigurationSection section) {
        Object result = SerializationHelper.deserialize(input, this.options().continueOnSerializationError());
        if (result instanceof Map) {
            input = (Map)result;
            for (Map.Entry entry : input.entrySet()) {
                String key = entry.getKey().toString();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    this.convertMapsToSections((Map)value, section.createSection(key));
                    continue;
                }
                section.set(key, value);
            }
        } else {
            section.set("", result);
        }
    }

    protected String buildHeader() {
        return "";
    }

    public JsonConfigurationOptions options() {
        if (this.options == null) {
            this.options = new JsonConfigurationOptions(this);
        }
        return (JsonConfigurationOptions)this.options;
    }

    private static JsonConfiguration loadConfiguration(@NotNull JsonConfiguration config, @NotNull File file) {
        try {
            config.load(file);
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.SEVERE, "Cannot find file " + file, ex);
        }
        catch (IOException | InvalidConfigurationException ex) {
            LOG.log(Level.SEVERE, "Cannot load " + file, ex);
        }
        return config;
    }

    public static JsonConfiguration loadConfiguration(@NotNull File file) {
        return JsonConfiguration.loadConfiguration(new JsonConfiguration(), file);
    }

    public JsonConfiguration() {
        ConfigurationSerialization.registerClass(SerializableSet.class);
    }
}

