/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.share;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Statistic;
import org.bukkit.World;
import org.bukkit.advancement.AdvancementProgress;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.mvplugins.multiverse.core.economy.MVEconomist;
import org.mvplugins.multiverse.core.teleportation.AsyncSafetyTeleporter;
import org.mvplugins.multiverse.core.utils.ReflectHelper;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.data.ProfileData;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.share.InventorySerializer;
import org.mvplugins.multiverse.inventories.share.ItemStackSerializer;
import org.mvplugins.multiverse.inventories.share.LocationSerializer;
import org.mvplugins.multiverse.inventories.share.PotionEffectSerializer;
import org.mvplugins.multiverse.inventories.share.ProfileEntry;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.share.SharableGroup;
import org.mvplugins.multiverse.inventories.share.SharableHandler;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MinecraftTools;
import org.mvplugins.multiverse.inventories.util.RespawnLocation;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class Sharables
implements Shares {
    private static final Shares ALL_SHARABLES;
    private static final Shares STANDARD_SHARABLES;
    private static final Shares OPTIONAL_SHARABLES;
    static final Map<String, Shares> LOOKUP_MAP;
    private static Shares enabledShares;
    private static MultiverseInventories inventories;
    private static InventoriesConfig inventoriesConfig;
    private static WorldGroupManager worldGroupManager;
    private static MVEconomist economist;
    private static AsyncSafetyTeleporter safetyTeleporter;
    private static Attribute maxHealthAttr;
    public static final Sharable<ItemStack[]> ENDER_CHEST;
    public static final Sharable<ItemStack[]> INVENTORY;
    public static final Sharable<ItemStack[]> ARMOR;
    public static final Sharable<ItemStack> OFF_HAND;
    public static final Sharable<Double> MAX_HEALTH;
    public static final Sharable<Double> HEALTH;
    public static final Sharable<Integer> REMAINING_AIR;
    public static final Sharable<Integer> MAXIMUM_AIR;
    public static final Sharable<Float> FALL_DISTANCE;
    public static final Sharable<Integer> FIRE_TICKS;
    public static final Sharable<Float> EXPERIENCE;
    public static final Sharable<Integer> LEVEL;
    public static final Sharable<Integer> TOTAL_EXPERIENCE;
    public static final Sharable<Integer> FOOD_LEVEL;
    public static final Sharable<Float> EXHAUSTION;
    public static final Sharable<Float> SATURATION;
    public static final Sharable<Location> BED_SPAWN;
    private static final boolean hasSetSpawnEvent;
    public static final Sharable<Location> LAST_LOCATION;
    public static final Sharable<Double> ECONOMY;
    public static final Sharable<PotionEffect[]> POTIONS;
    public static final Sharable<List> ADVANCEMENTS;
    private static final Option<GameRule<Boolean>> announceAdvancementsRule;
    private static final Consumer<Player> sendAdvancementUpdateWithoutToast;
    public static final Sharable<Map> GAME_STATISTICS;
    public static final Sharable<List> RECIPES;
    public static final Shares ALL_INVENTORY;
    public static final Shares ALL_EXPERIENCE;
    public static final Shares AIR;
    public static final SharableGroup HUNGER;
    public static final SharableGroup ALL_HEALTH;
    public static final SharableGroup STATS;
    public static final SharableGroup ALL_DEFAULT;
    private Set<Sharable> sharables;

    public static void init(MultiverseInventories inventories) {
        Sharables.inventories = inventories;
        economist = (MVEconomist)inventories.getServiceLocator().getService(MVEconomist.class, new Annotation[0]);
        safetyTeleporter = (AsyncSafetyTeleporter)inventories.getServiceLocator().getService(AsyncSafetyTeleporter.class, new Annotation[0]);
        inventoriesConfig = (InventoriesConfig)inventories.getServiceLocator().getService(InventoriesConfig.class, new Annotation[0]);
        worldGroupManager = (WorldGroupManager)inventories.getServiceLocator().getService(WorldGroupManager.class, new Annotation[0]);
        Sharables.initMaxHealthAttr();
    }

    private static void initMaxHealthAttr() {
        maxHealthAttr = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"max_health"));
        if (maxHealthAttr == null) {
            maxHealthAttr = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.max_health"));
        }
        if (maxHealthAttr == null) {
            InvLogging.warning("Could not find max_health attribute. Health related sharables may not work as expected.", new Object[0]);
        }
    }

    private static double getDefaultMaxHealth(Player player) {
        return (Double)Option.of((Object)maxHealthAttr).map(arg_0 -> ((Player)player).getAttribute(arg_0)).map(AttributeInstance::getDefaultValue).getOrElse((Object)20.0);
    }

    private static double getBaseHealth(Player player) {
        return (Double)Option.of((Object)maxHealthAttr).map(arg_0 -> ((Player)player).getAttribute(arg_0)).map(AttributeInstance::getBaseValue).getOrElse((Object)20.0);
    }

    private static void setBaseHealth(Player player, double value) {
        Option.of((Object)maxHealthAttr).map(arg_0 -> ((Player)player).getAttribute(arg_0)).peek(attr -> attr.setBaseValue(value));
    }

    private static double getMaxHealth(Player player) {
        return (Double)Option.of((Object)maxHealthAttr).map(arg_0 -> ((Player)player).getAttribute(arg_0)).map(AttributeInstance::getValue).getOrElse((Object)20.0);
    }

    static boolean register(Sharable sharable) {
        if (!ALL_SHARABLES.contains(sharable) && inventories != null) {
            WorldGroupManager worldGroupManager = (WorldGroupManager)inventories.getServiceLocator().getService(WorldGroupManager.class, new Annotation[0]);
            for (WorldGroup group : worldGroupManager.getGroups()) {
                if (!group.getShares().isSharing(Sharables.all())) continue;
                group.getShares().setSharing(sharable, true);
            }
        }
        if (ALL_SHARABLES.add(sharable)) {
            if (sharable.isOptional()) {
                OPTIONAL_SHARABLES.add(sharable);
            } else {
                STANDARD_SHARABLES.add(sharable);
            }
            for (String name : sharable.getNames()) {
                String key = name.toLowerCase();
                Shares shares = LOOKUP_MAP.get(key);
                if (shares == null) {
                    shares = Sharables.noneOf();
                    LOOKUP_MAP.put(key, shares);
                }
                shares.add(sharable);
            }
            return true;
        }
        return false;
    }

    public static Shares lookup(String name) {
        return LOOKUP_MAP.get(name.toLowerCase());
    }

    public static Collection<String> getShareNames() {
        return LOOKUP_MAP.keySet();
    }

    public static Shares all() {
        return ALL_SHARABLES;
    }

    public static Shares standard() {
        return STANDARD_SHARABLES;
    }

    public static Shares enabled() {
        return enabledShares;
    }

    public static Shares optional() {
        return OPTIONAL_SHARABLES;
    }

    public static Shares allOf() {
        return new Sharables(new LinkedHashSet<Sharable>(ALL_SHARABLES));
    }

    public static Shares enabledOf() {
        return new Sharables(new LinkedHashSet<Sharable>(enabledShares));
    }

    public static Shares standardOf() {
        return new Sharables(new LinkedHashSet<Sharable>(STANDARD_SHARABLES));
    }

    public static Shares optionalOf() {
        return new Sharables(new LinkedHashSet<Sharable>(OPTIONAL_SHARABLES));
    }

    public static Shares noneOf() {
        return new Sharables(new LinkedHashSet<Sharable>(ALL_SHARABLES.size()));
    }

    public static Shares complimentOf(Shares shares) {
        Shares compliment = Sharables.allOf();
        compliment.removeAll(shares);
        return compliment;
    }

    public static Shares fromShares(Shares shares) {
        return new Sharables(shares);
    }

    public static Shares fromCollection(Collection<Sharable> sharesCollection) {
        Shares shares = Sharables.noneOf();
        shares.addAll(sharesCollection);
        return shares;
    }

    public static Shares fromSharables(Sharable ... sharables) {
        Shares shares = Sharables.noneOf();
        shares.addAll(Arrays.asList(sharables));
        return shares;
    }

    public static Shares negativeFromList(List sharesList) {
        Shares shares = Sharables.noneOf();
        for (Object shareStringObj : sharesList) {
            String shareString = shareStringObj.toString();
            if (!shareString.startsWith("-") || shareString.length() <= 1) continue;
            Shares sharables = Sharables.lookup(shareString = shareString.substring(1));
            if (sharables != null) {
                shares.mergeShares(sharables);
                continue;
            }
            if (!shareString.equals("*") && !shareString.equalsIgnoreCase("all") && !shareString.equalsIgnoreCase("everything")) continue;
            shares = Sharables.allOf();
            break;
        }
        return shares;
    }

    public static Shares fromList(List sharesList) {
        Shares shares = Sharables.noneOf();
        for (Object shareStringObj : sharesList) {
            String shareString = shareStringObj.toString();
            Shares sharables = Sharables.lookup(shareString);
            if (sharables != null) {
                shares.mergeShares(sharables);
                continue;
            }
            if (!shareString.equals("*") && !shareString.equalsIgnoreCase("all") && !shareString.equalsIgnoreCase("everything")) continue;
            shares = Sharables.allOf();
            break;
        }
        return shares;
    }

    public static void recalculateEnabledShares() {
        InvLogging.finer("Recalculating enabled shares...", new Object[0]);
        enabledShares = Sharables.standardOf();
        enabledShares.addAll(inventoriesConfig.getActiveOptionalShares());
        worldGroupManager.recalculateApplicableShares();
    }

    private Sharables(Set<Sharable> sharableSet) {
        this.sharables = sharableSet;
    }

    private Sharables(Shares shares) {
        this.sharables = new LinkedHashSet<Sharable>(ALL_SHARABLES.size());
        this.sharables.addAll(shares);
    }

    @Override
    public int size() {
        return this.sharables.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sharables.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.sharables.contains(o);
    }

    @Override
    public Iterator<Sharable> iterator() {
        return this.sharables.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.sharables.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.sharables.toArray(a);
    }

    @Override
    public boolean add(Sharable sharable) {
        return this.sharables.add(sharable);
    }

    @Override
    public boolean remove(Object o) {
        return this.sharables.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.sharables.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Sharable> c) {
        return this.sharables.addAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.sharables.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.sharables.removeAll(c);
    }

    @Override
    public void clear() {
        this.sharables.clear();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof Shares && ((Shares)o).isSharing(this);
    }

    @Override
    public int hashCode() {
        return this.sharables.hashCode();
    }

    @Override
    public void mergeShares(Shares newShares) {
        this.addAll(newShares);
    }

    @Override
    public Shares setSharing(Sharable sharable, boolean sharing) {
        if (sharing) {
            this.add(sharable);
        } else {
            this.remove(sharable);
        }
        return this;
    }

    @Override
    public Shares setSharing(Shares sharables, boolean sharing) {
        for (Sharable sharable : sharables) {
            if (sharing) {
                this.add(sharable);
                continue;
            }
            this.remove(sharable);
        }
        return this;
    }

    @Override
    public Shares compare(Shares shares) {
        Shares bothSharing = Sharables.noneOf();
        for (Sharable sharable : shares) {
            if (!this.contains(sharable)) continue;
            bothSharing.add(sharable);
        }
        return bothSharing;
    }

    @Override
    public boolean isSharing(Sharable sharable) {
        return this.contains(sharable);
    }

    @Override
    public boolean isSharing(Shares shares) {
        boolean isSharing = this.sharables.equals(shares);
        if (!isSharing) {
            for (Sharable sharable : shares) {
                if (this.isSharing(sharable)) continue;
                return false;
            }
            isSharing = true;
        }
        return isSharing;
    }

    @Override
    public List<String> toStringList() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.isSharing(Sharables.allOf())) {
            list.add("all");
        } else {
            for (Sharable sharable : this) {
                list.add(sharable.toString());
            }
        }
        return list;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Sharable sharable : this) {
            if (!stringBuilder.toString().isEmpty()) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(sharable);
        }
        return stringBuilder.toString();
    }

    static {
        Option rule;
        ALL_SHARABLES = new Sharables(new LinkedHashSet<Sharable>());
        STANDARD_SHARABLES = new Sharables(new LinkedHashSet<Sharable>());
        OPTIONAL_SHARABLES = new Sharables(new LinkedHashSet<Sharable>());
        LOOKUP_MAP = new HashMap<String, Shares>();
        enabledShares = Sharables.noneOf();
        inventories = null;
        inventoriesConfig = null;
        worldGroupManager = null;
        economist = null;
        safetyTeleporter = null;
        maxHealthAttr = null;
        ENDER_CHEST = new Sharable.Builder<ItemStack[]>("ender_chest", ItemStack[].class, new SharableHandler<ItemStack[]>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(ENDER_CHEST, player.getEnderChest().getContents());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                ItemStack[] value = profile.get(ENDER_CHEST);
                Inventory enderChest = player.getEnderChest();
                if (value == null) {
                    enderChest.setContents(MinecraftTools.fillWithAir(new ItemStack[enderChest.getSize()]));
                    return false;
                }
                if (value.length != enderChest.getSize()) {
                    InvLogging.fine("Mismatch ender chest size found in profile for player " + player.getName() + ". Expected " + enderChest.getSize() + " but got " + value.length + ".", new Object[0]);
                }
                enderChest.setContents(value);
                return true;
            }
        }).serializer(new ProfileEntry(false, "enderChestContents"), new InventorySerializer.EnderChestSerializer()).altName("ender").build();
        INVENTORY = new Sharable.Builder<ItemStack[]>("inventory_contents", ItemStack[].class, new SharableHandler<ItemStack[]>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(INVENTORY, player.getInventory().getStorageContents());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                ItemStack[] value = profile.get(INVENTORY);
                if (value == null) {
                    player.getInventory().setStorageContents(MinecraftTools.fillWithAir(new ItemStack[36]));
                    return false;
                }
                player.getInventory().setStorageContents(value);
                return true;
            }
        }).serializer(new ProfileEntry(false, "inventoryContents"), new InventorySerializer.MainInventorySerializer()).build();
        ARMOR = new Sharable.Builder<ItemStack[]>("armor_contents", ItemStack[].class, new SharableHandler<ItemStack[]>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(ARMOR, player.getInventory().getArmorContents());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                ItemStack[] value = profile.get(ARMOR);
                if (value == null) {
                    player.getInventory().setArmorContents(MinecraftTools.fillWithAir(new ItemStack[4]));
                    return false;
                }
                player.getInventory().setArmorContents(value);
                return true;
            }
        }).serializer(new ProfileEntry(false, "armorContents"), new InventorySerializer.ArmorSerializer()).altName("armor").build();
        OFF_HAND = new Sharable.Builder<ItemStack>("off_hand", ItemStack.class, new SharableHandler<ItemStack>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(OFF_HAND, player.getInventory().getItemInOffHand());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                ItemStack value = profile.get(OFF_HAND);
                if (value == null) {
                    player.getInventory().setItemInOffHand(new ItemStack(Material.AIR));
                    return false;
                }
                player.getInventory().setItemInOffHand(value);
                return true;
            }
        }).serializer(new ProfileEntry(false, "offHandItem"), new ItemStackSerializer()).altName("shield").build();
        MAX_HEALTH = new Sharable.Builder<Double>("max_hit_points", Double.class, new SharableHandler<Double>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(MAX_HEALTH, Sharables.getBaseHealth(player));
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Double value = profile.get(MAX_HEALTH);
                if (value == null) {
                    Sharables.setBaseHealth(player, Sharables.getDefaultMaxHealth(player));
                    return false;
                }
                Sharables.setBaseHealth(player, value);
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "mhp")).altName("maxhealth").altName("maxhp").altName("maxhitpoints").build();
        HEALTH = new Sharable.Builder<Double>("hit_points", Double.class, new SharableHandler<Double>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                double health = player.getHealth();
                if (health <= 0.0) {
                    health = Sharables.getMaxHealth(player);
                }
                profile.set(HEALTH, health);
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Double value = profile.get(HEALTH);
                try {
                    if (value == null) {
                        player.setHealth(20.0);
                        return false;
                    }
                    if (value < 0.0) {
                        player.setHealth(0.0);
                        return false;
                    }
                    if (value > Sharables.getMaxHealth(player)) {
                        Sharables.setBaseHealth(player, Objects.requireNonNullElse(profile.get(MAX_HEALTH), Sharables.getDefaultMaxHealth(player)));
                    }
                    double newMaxHealth = Sharables.getMaxHealth(player);
                    player.setHealth(value > newMaxHealth ? newMaxHealth : value);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    InvLogging.warning("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    return false;
                }
            }
        }).stringSerializer(new ProfileEntry(true, "hp")).altName("health").altName("hp").altName("hitpoints").build();
        REMAINING_AIR = new Sharable.Builder<Integer>("remaining_air", Integer.class, new SharableHandler<Integer>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(REMAINING_AIR, player.getRemainingAir());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Integer value = profile.get(REMAINING_AIR);
                if (value == null) {
                    player.setRemainingAir(300);
                    return false;
                }
                try {
                    player.setRemainingAir(value.intValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setRemainingAir(300);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "ra")).build();
        MAXIMUM_AIR = new Sharable.Builder<Integer>("maximum_air", Integer.class, new SharableHandler<Integer>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(MAXIMUM_AIR, player.getMaximumAir());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Integer value = profile.get(MAXIMUM_AIR);
                if (value == null) {
                    player.setMaximumAir(300);
                    return false;
                }
                try {
                    player.setMaximumAir(value.intValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setMaximumAir(300);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "ma")).build();
        FALL_DISTANCE = new Sharable.Builder<Float>("fall_distance", Float.class, new SharableHandler<Float>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(FALL_DISTANCE, Float.valueOf(player.getFallDistance()));
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Float value = profile.get(FALL_DISTANCE);
                if (value == null) {
                    player.setFallDistance(0.0f);
                    return false;
                }
                try {
                    player.setFallDistance(value.floatValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setFallDistance(0.0f);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "fd")).altName("falling").build();
        FIRE_TICKS = new Sharable.Builder<Integer>("fire_ticks", Integer.class, new SharableHandler<Integer>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(FIRE_TICKS, player.getFireTicks());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Integer value = profile.get(FIRE_TICKS);
                if (value == null) {
                    player.setFireTicks(0);
                    return false;
                }
                try {
                    player.setFireTicks(value.intValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setFireTicks(0);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "ft")).altName("fire").altName("burning").build();
        EXPERIENCE = new Sharable.Builder<Float>("xp", Float.class, new SharableHandler<Float>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(EXPERIENCE, Float.valueOf(player.getExp()));
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Float value = profile.get(EXPERIENCE);
                if (value == null) {
                    player.setExp(0.0f);
                    return false;
                }
                try {
                    player.setExp(value.floatValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setExp(0.0f);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "xp")).build();
        LEVEL = new Sharable.Builder<Integer>("lvl", Integer.class, new SharableHandler<Integer>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(LEVEL, player.getLevel());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Integer value = profile.get(LEVEL);
                if (value == null) {
                    player.setLevel(0);
                    return false;
                }
                try {
                    player.setLevel(value.intValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setLevel(0);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "el")).build();
        TOTAL_EXPERIENCE = new Sharable.Builder<Integer>("total_xp", Integer.class, new SharableHandler<Integer>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(TOTAL_EXPERIENCE, player.getTotalExperience());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Integer value = profile.get(TOTAL_EXPERIENCE);
                if (value == null) {
                    player.setTotalExperience(0);
                    return false;
                }
                try {
                    player.setTotalExperience(value.intValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setTotalExperience(0);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "txp")).build();
        FOOD_LEVEL = new Sharable.Builder<Integer>("food_level", Integer.class, new SharableHandler<Integer>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(FOOD_LEVEL, player.getFoodLevel());
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Integer value = profile.get(FOOD_LEVEL);
                if (value == null) {
                    player.setFoodLevel(20);
                    return false;
                }
                try {
                    player.setFoodLevel(value.intValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setFoodLevel(20);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "fl")).altName("food").build();
        EXHAUSTION = new Sharable.Builder<Float>("exhaustion", Float.class, new SharableHandler<Float>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(EXHAUSTION, Float.valueOf(player.getExhaustion()));
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Float value = profile.get(EXHAUSTION);
                if (value == null) {
                    player.setExhaustion(0.0f);
                    return false;
                }
                try {
                    player.setExhaustion(value.floatValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setExhaustion(0.0f);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "ex")).altName("exhaust").altName("exh").build();
        SATURATION = new Sharable.Builder<Float>("saturation", Float.class, new SharableHandler<Float>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                profile.set(SATURATION, Float.valueOf(player.getSaturation()));
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Float value = profile.get(SATURATION);
                if (value == null) {
                    player.setSaturation(5.0f);
                    return false;
                }
                try {
                    player.setSaturation(value.floatValue());
                }
                catch (IllegalArgumentException e) {
                    InvLogging.fine("Invalid value '" + value + "': " + e.getMessage(), new Object[0]);
                    player.setSaturation(5.0f);
                    return false;
                }
                return true;
            }
        }).stringSerializer(new ProfileEntry(true, "sa")).altName("sat").build();
        BED_SPAWN = new Sharable.Builder<Location>("bed_spawn", Location.class, new SharableHandler<Location>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                if (hasSetSpawnEvent) {
                    return;
                }
                Location bedSpawnLocation = null;
                try {
                    InvLogging.finer("profile bed: " + String.valueOf(player.getBedSpawnLocation()), new Object[0]);
                    bedSpawnLocation = MinecraftTools.findBedFromRespawnLocation(player.getBedSpawnLocation());
                }
                catch (NullPointerException e) {
                    StackTraceElement[] stackTrace = e.getStackTrace();
                    Object error = stackTrace.length > 1 ? stackTrace[0].toString() + String.valueOf(stackTrace[1]) : "NullPointerException thrown by Player#getBedSpawnLocation";
                    InvLogging.warning((String)error + " - See https://github.com/Multiverse/Multiverse-Inventories/issues/374 for more details.", new Object[0]);
                }
                profile.set(BED_SPAWN, bedSpawnLocation);
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                RespawnLocation respawnLocation;
                Location loc = profile.get(BED_SPAWN);
                if (loc == null) {
                    InvLogging.finer("No respawn location saved", new Object[0]);
                    player.setBedSpawnLocation(player.getWorld().getSpawnLocation(), true);
                    return false;
                }
                World loclWorld = (World)Try.of(() -> ((Location)loc).getWorld()).getOrNull();
                if (loclWorld == null) {
                    InvLogging.warning("Respawn location has invalid world!", new Object[0]);
                    player.setBedSpawnLocation(player.getWorld().getSpawnLocation(), true);
                    return false;
                }
                if (inventoriesConfig.getValidateBedAnchorRespawnLocation() && loc instanceof RespawnLocation && !(respawnLocation = (RespawnLocation)loc).isValidRespawnLocation()) {
                    InvLogging.finer("Respawn location validation failed for respawn type: " + String.valueOf((Object)respawnLocation.getRespawnType()), new Object[0]);
                    player.setBedSpawnLocation(player.getWorld().getSpawnLocation(), true);
                    return false;
                }
                player.setBedSpawnLocation(loc, true);
                InvLogging.finer("updated respawn location: " + String.valueOf(player.getBedSpawnLocation()), new Object[0]);
                return true;
            }
        }).serializer(new ProfileEntry(false, "bedSpawnLocation"), new LocationSerializer.RespawnLocationSerializer()).altName("bedspawn").altName("bed").altName("beds").altName("bedspawns").build();
        hasSetSpawnEvent = ReflectHelper.hasClass((String)"org.bukkit.event.player.PlayerSpawnChangeEvent") || ReflectHelper.hasClass((String)"com.destroystokyo.paper.event.player.PlayerSetSpawnEvent");
        LAST_LOCATION = new Sharable.Builder<Location>("last_location", Location.class, new SharableHandler<Location>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Location loc = profile.get(LAST_LOCATION);
                if (loc == null || loc.getWorld() == null || loc.equals((Object)player.getLocation())) {
                    return false;
                }
                safetyTeleporter.to(loc).checkSafety(false).teleportSingle((Entity)player);
                return true;
            }
        }).serializer(new ProfileEntry(false, "lastLocation"), new LocationSerializer.UnloadedWorldLocationSerializer()).altName("loc").altName("location").altName("pos").altName("position").optional().build();
        ECONOMY = new Sharable.Builder<Double>("economy", Double.class, new SharableHandler<Double>(){

            private boolean hasValidEconomyHandler() {
                if (economist.isUsingEconomyPlugin()) {
                    return true;
                }
                InvLogging.warning("You do not have an an economy plugin with Vault. Economy sharable will not work!", new Object[0]);
                InvLogging.warning("Check that your economy and vault plugin are both working correctly.", new Object[0]);
                InvLogging.warning("If you enabled the sharable by mistake, run '/mvinv toggle economy' to resolve this.", new Object[0]);
                return false;
            }

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                if (!this.hasValidEconomyHandler()) {
                    return;
                }
                profile.set(ECONOMY, economist.getBalance(player));
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                if (!this.hasValidEconomyHandler()) {
                    return false;
                }
                Double money = profile.get(ECONOMY);
                if (money == null) {
                    economist.setBalance(player, 0.0);
                    return false;
                }
                economist.setBalance(player, money.doubleValue());
                return true;
            }
        }).stringSerializer(new ProfileEntry(false, "balance")).optional().altName("money").altName("econ").altName("cash").altName("balance").build();
        POTIONS = new Sharable.Builder<PotionEffect[]>("potion_effects", PotionEffect[].class, new SharableHandler<PotionEffect[]>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                Collection potionEffects = player.getActivePotionEffects();
                profile.set(POTIONS, potionEffects.toArray(new PotionEffect[potionEffects.size()]));
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                PotionEffect[] effects = profile.get(POTIONS);
                for (PotionEffect effect : player.getActivePotionEffects()) {
                    player.removePotionEffect(effect.getType());
                }
                if (effects == null) {
                    return false;
                }
                for (PotionEffect effect : effects) {
                    player.addPotionEffect(effect);
                }
                return true;
            }
        }).serializer(new ProfileEntry(false, "potions"), new PotionEffectSerializer()).altName("potion").altName("potions").build();
        ADVANCEMENTS = new Sharable.Builder<List>("advancements", List.class, new SharableHandler<List>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                HashSet completedAdvancements = new HashSet();
                Bukkit.advancementIterator().forEachRemaining(advancement -> {
                    Collection awardedCriteria = player.getAdvancementProgress(advancement).getAwardedCriteria();
                    completedAdvancements.addAll(awardedCriteria);
                });
                profile.set(ADVANCEMENTS, new ArrayList(completedAdvancements));
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                List advancements = profile.get(ADVANCEMENTS);
                HashSet completedCriteria = advancements != null ? new HashSet(advancements) : Collections.emptySet();
                int totalExperience = player.getTotalExperience();
                int level = player.getLevel();
                float exp = player.getExp();
                boolean announceAdvancements = (Boolean)announceAdvancementsRule.map(rule -> Boolean.TRUE.equals(player.getWorld().getGameRuleValue(rule))).filter(Boolean::booleanValue).map(ignore -> player.getWorld().setGameRule((GameRule)announceAdvancementsRule.get(), (Object)false)).getOrElse((Object)false);
                Bukkit.advancementIterator().forEachRemaining(advancement -> {
                    AdvancementProgress advancementProgress = player.getAdvancementProgress(advancement);
                    for (String criteria : advancement.getCriteria()) {
                        if (completedCriteria.contains(criteria)) {
                            advancementProgress.awardCriteria(criteria);
                            continue;
                        }
                        advancementProgress.revokeCriteria(criteria);
                    }
                });
                player.setExp(exp);
                player.setLevel(level);
                player.setTotalExperience(totalExperience);
                sendAdvancementUpdateWithoutToast.accept(player);
                if (announceAdvancements && announceAdvancementsRule.isDefined()) {
                    announceAdvancementsRule.peek(rule -> player.getWorld().setGameRule(rule, (Object)true));
                }
                return advancements != null;
            }
        }).defaultSerializer(new ProfileEntry(false, "advancements")).altName("achievements").optional().build();
        Option craftPlayerClass = Option.of((Object)ReflectHelper.getClass((String)"org.bukkit.craftbukkit.entity.CraftPlayer"));
        Option getHandleMethod = craftPlayerClass.map(cls -> ReflectHelper.getMethod((Class)cls, (String)"getHandle", (Class[])new Class[0]));
        Option serverPlayerClass = Option.of((Object)ReflectHelper.getClass((String)"net.minecraft.server.level.ServerPlayer"));
        Option getAdvancementsMethod = serverPlayerClass.map(cls -> ReflectHelper.getMethod((Class)cls, (String)"getAdvancements", (Class[])new Class[0]));
        Option playerAdvancementsClass = Option.of((Object)ReflectHelper.getClass((String)"net.minecraft.server.PlayerAdvancements"));
        Option flushDirtyMethod = playerAdvancementsClass.flatMap(cls -> serverPlayerClass.map(cls2 -> ReflectHelper.getMethod((Class)cls, (String)"flushDirty", (Class[])new Class[]{cls2, Boolean.TYPE})));
        sendAdvancementUpdateWithoutToast = player -> getHandleMethod.flatMap(method -> Try.of((CheckedFunction0 & Serializable)() -> method.invoke(player, new Object[0])).toOption()).flatMap(serverPlayer -> getAdvancementsMethod.flatMap(method -> Try.of((CheckedFunction0 & Serializable)() -> method.invoke(serverPlayer, new Object[0])).toOption()).flatMap(playerAdvancements -> flushDirtyMethod.flatMap(method -> Try.of((CheckedFunction0 & Serializable)() -> method.invoke(playerAdvancements, serverPlayer, false)).toOption())));
        announceAdvancementsRule = rule = Try.of((CheckedFunction0 & Serializable)() -> (GameRule)Option.of((Object)GameRule.getByName((String)"announceAdvancements")).getOrElse(() -> GameRule.getByName((String)"minecraft:show_advancement_messages"))).toOption();
        GAME_STATISTICS = new Sharable.Builder<Map>("game_statistics", Map.class, new SharableHandler<Map>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                HashMap<String, Serializable> playerStats = new HashMap<String, Serializable>();
                block6: for (Statistic stat : Statistic.values()) {
                    switch (stat.getType()) {
                        case UNTYPED: {
                            int val = player.getStatistic(stat);
                            if (val == 0) continue block6;
                            playerStats.put(stat.name(), Integer.valueOf(val));
                            continue block6;
                        }
                        case ITEM: {
                            int val;
                            HashMap<String, Integer> itemStats = new HashMap<String, Integer>();
                            for (Material material : Material.values()) {
                                if (!material.isItem() || (val = player.getStatistic(stat, material)) == 0) continue;
                                itemStats.put(material.getKey().toString(), val);
                            }
                            if (itemStats.isEmpty()) continue block6;
                            playerStats.put(stat.name(), itemStats);
                            continue block6;
                        }
                        case BLOCK: {
                            int val;
                            HashMap blockStats = new HashMap();
                            for (Material material : Material.values()) {
                                if (!material.isBlock() || (val = player.getStatistic(stat, material)) == 0) continue;
                                playerStats.put(material.getKey().toString(), Integer.valueOf(val));
                            }
                            if (blockStats.isEmpty()) continue block6;
                            playerStats.put(stat.name(), blockStats);
                            continue block6;
                        }
                        case ENTITY: {
                            int val;
                            HashMap<String, Integer> entityStats = new HashMap<String, Integer>();
                            for (Material material : EntityType.values()) {
                                if (material == EntityType.UNKNOWN || (val = player.getStatistic(stat, (EntityType)material)) == 0) continue;
                                entityStats.put(material.getKey().toString(), val);
                            }
                            if (entityStats.isEmpty()) continue block6;
                            playerStats.put(stat.name(), entityStats);
                        }
                    }
                }
                profile.set(GAME_STATISTICS, playerStats);
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                Map playerStats = profile.get(GAME_STATISTICS);
                boolean hasData = true;
                if (playerStats == null) {
                    playerStats = Collections.emptyMap();
                    hasData = false;
                }
                block6: for (Statistic stat : Statistic.values()) {
                    Object value = playerStats.get(stat.name());
                    switch (stat.getType()) {
                        case UNTYPED: {
                            if (value == null) {
                                player.setStatistic(stat, 0);
                                continue block6;
                            }
                            if (!(value instanceof Integer)) {
                                InvLogging.warning("Invalid statistic value for " + stat.name() + ": " + String.valueOf(value), new Object[0]);
                                continue block6;
                            }
                            Integer intValue = (Integer)value;
                            Try.run(() -> player.setStatistic(stat, intValue.intValue())).onFailure(ex -> InvLogging.warning("Failed to set statistic " + stat.name() + ": " + ex.getMessage(), new Object[0]));
                            continue block6;
                        }
                        case ITEM: {
                            Integer intValue;
                            Integer matValue;
                            if (value == null) {
                                value = Collections.emptyMap();
                            }
                            if (!(value instanceof Map)) {
                                InvLogging.warning("Invalid statistic value for " + stat.name() + ": " + String.valueOf(value), new Object[0]);
                                continue block6;
                            }
                            Map itemMap = (Map)value;
                            for (Material material : Material.values()) {
                                if (!material.isItem()) continue;
                                matValue = itemMap.getOrDefault(material.getKey().toString(), 0);
                                if (!(matValue instanceof Integer)) {
                                    InvLogging.warning("Invalid statistic value for " + stat.name() + " and item " + material.name() + ": " + String.valueOf(matValue), new Object[0]);
                                    continue;
                                }
                                intValue = matValue;
                                Try.run(() -> player.setStatistic(stat, mat, intValue.intValue())).onFailure(ex -> InvLogging.warning("Failed to set statistic " + stat.name() + " for item " + mat.name() + ": " + ex.getMessage(), new Object[0]));
                            }
                            continue block6;
                        }
                        case BLOCK: {
                            Integer intValue;
                            Integer matValue;
                            if (value == null) {
                                value = Collections.emptyMap();
                            }
                            if (!(value instanceof Map)) {
                                InvLogging.warning("Invalid statistic value for " + stat.name() + ": " + String.valueOf(value), new Object[0]);
                                continue block6;
                            }
                            Map blockMap = (Map)value;
                            for (Material material : Material.values()) {
                                if (!material.isBlock()) continue;
                                matValue = blockMap.getOrDefault(material.getKey().toString(), 0);
                                if (!(matValue instanceof Integer)) {
                                    InvLogging.warning("Invalid statistic value for " + stat.name() + " and block " + material.name() + ": " + String.valueOf(matValue), new Object[0]);
                                    continue;
                                }
                                intValue = matValue;
                                Try.run(() -> player.setStatistic(stat, mat, intValue.intValue())).onFailure(ex -> InvLogging.warning("Failed to set statistic " + stat.name() + " for block " + mat.name() + ": " + ex.getMessage(), new Object[0]));
                            }
                            continue block6;
                        }
                        case ENTITY: {
                            Integer intValue;
                            if (value == null) {
                                value = Collections.emptyMap();
                            }
                            if (!(value instanceof Map)) {
                                InvLogging.warning("Invalid statistic value for " + stat.name() + ": " + String.valueOf(value), new Object[0]);
                                continue block6;
                            }
                            Map entityMap = (Map)value;
                            for (Material material : EntityType.values()) {
                                if (material == EntityType.UNKNOWN) continue;
                                Integer entityValue = entityMap.getOrDefault(material.getKey().toString(), 0);
                                if (!(entityValue instanceof Integer)) {
                                    InvLogging.warning("Invalid statistic value for " + stat.name() + " and entity " + material.name() + ": " + String.valueOf(entityValue), new Object[0]);
                                    continue;
                                }
                                intValue = entityValue;
                                Try.run(() -> 22.lambda$updatePlayer$6(player, stat, (EntityType)material, intValue)).onFailure(arg_0 -> 22.lambda$updatePlayer$7(stat, (EntityType)material, arg_0));
                            }
                            continue block6;
                        }
                    }
                }
                return hasData;
            }

            private static /* synthetic */ void lambda$updatePlayer$7(Statistic stat, EntityType entityType, Throwable ex) {
                InvLogging.warning("Failed to set statistic " + stat.name() + " for entity " + entityType.name() + ": " + ex.getMessage(), new Object[0]);
            }

            private static /* synthetic */ void lambda$updatePlayer$6(Player player, Statistic stat, EntityType entityType, Integer intValue) throws Throwable {
                player.setStatistic(stat, entityType, intValue.intValue());
            }
        }).defaultSerializer(new ProfileEntry(false, "game_statistics")).altName("game_stats").optional().build();
        RECIPES = new Sharable.Builder<List>("recipes", List.class, new SharableHandler<List>(){

            @Override
            public void updateProfile(ProfileData profile, Player player) {
                List<String> recipes = player.getDiscoveredRecipes().stream().map(key -> "minecraft".equals(key.getNamespace()) ? key.getKey() : key.toString()).toList();
                profile.set(RECIPES, recipes);
            }

            @Override
            public boolean updatePlayer(Player player, ProfileData profile) {
                List recipes = profile.get(RECIPES);
                if (recipes == null) {
                    player.undiscoverRecipes((Collection)player.getDiscoveredRecipes());
                    return false;
                }
                Set discoveredRecipes = player.getDiscoveredRecipes();
                Set toDiscover = recipes.stream().map(NamespacedKey::fromString).filter(Objects::nonNull).collect(Collectors.toSet());
                player.undiscoverRecipes((Collection)Sets.difference((Set)discoveredRecipes, toDiscover));
                player.discoverRecipes((Collection)Sets.difference(toDiscover, (Set)discoveredRecipes));
                return true;
            }
        }).defaultSerializer(new ProfileEntry(false, "recipes")).optional().build();
        ALL_INVENTORY = new SharableGroup("inventory", Sharables.fromSharables(INVENTORY, ARMOR, ENDER_CHEST, OFF_HAND), "inv", "inventories");
        ALL_EXPERIENCE = new SharableGroup("experience", Sharables.fromSharables(EXPERIENCE, TOTAL_EXPERIENCE, LEVEL), "exp", "level");
        AIR = new SharableGroup("air", Sharables.fromSharables(REMAINING_AIR, MAXIMUM_AIR), "breath");
        HUNGER = new SharableGroup("hunger", Sharables.fromSharables(FOOD_LEVEL, SATURATION, EXHAUSTION), new String[0]);
        ALL_HEALTH = new SharableGroup("health", Sharables.fromSharables(HEALTH, MAX_HEALTH, REMAINING_AIR, MAXIMUM_AIR, FALL_DISTANCE, FIRE_TICKS), new String[0]);
        STATS = new SharableGroup("stats", Sharables.fromSharables(HEALTH, MAX_HEALTH, FOOD_LEVEL, SATURATION, EXHAUSTION, EXPERIENCE, TOTAL_EXPERIENCE, LEVEL, REMAINING_AIR, MAXIMUM_AIR, FALL_DISTANCE, FIRE_TICKS, POTIONS, GAME_STATISTICS, ADVANCEMENTS), new String[0]);
        ALL_DEFAULT = new SharableGroup("all", Sharables.fromSharables(HEALTH, MAX_HEALTH, ECONOMY, FOOD_LEVEL, SATURATION, EXHAUSTION, EXPERIENCE, TOTAL_EXPERIENCE, LEVEL, INVENTORY, ARMOR, BED_SPAWN, MAXIMUM_AIR, REMAINING_AIR, FALL_DISTANCE, FIRE_TICKS, POTIONS, LAST_LOCATION, ENDER_CHEST, OFF_HAND, GAME_STATISTICS, ADVANCEMENTS, RECIPES), "*", "everything");
    }
}

