/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.nbt;

import com.viaversion.nbt.io.NBTIO;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.profile.data.ProfileData;
import org.mvplugins.multiverse.inventories.profile.data.ProfileDataSnapshot;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Deprecated(since="5.3", forRemoval=true)
@Service
@ApiStatus.AvailableSince(value="5.2")
public final class PlayerDataExtractor {
    @ApiStatus.AvailableSince(value="5.2")
    public Try<ProfileData> extract(Path path) {
        return Try.of((CheckedFunction0 & Serializable)() -> {
            if (!path.toFile().exists()) {
                InvLogging.warning("File %s does not exist! %s", path);
                throw new IOException();
            }
            InvLogging.finest("Extracting %s", path);
            CompoundTag playerData = NBTIO.reader(CompoundTag.class).named().read(path, true);
            int dataVersion = playerData.getInt("DataVersion");
            InvLogging.finest("Data version: %s", dataVersion);
            CompoundTag equipment = playerData.getCompoundTag("equipment");
            if (equipment == null) {
                equipment = new CompoundTag();
            }
            ProfileDataSnapshot profileData = new ProfileDataSnapshot();
            profileData.set(Sharables.ARMOR, new ItemStack[]{this.extractItem(equipment.getCompoundTag("feet"), dataVersion), this.extractItem(equipment.getCompoundTag("legs"), dataVersion), this.extractItem(equipment.getCompoundTag("chest"), dataVersion), this.extractItem(equipment.getCompoundTag("head"), dataVersion)});
            profileData.set(Sharables.ENDER_CHEST, this.extractItems(playerData.getListTag("EnderItems", CompoundTag.class), dataVersion, 27));
            profileData.set(Sharables.EXHAUSTION, Float.valueOf(playerData.getFloat("foodExhaustionLevel")));
            profileData.set(Sharables.EXPERIENCE, Float.valueOf(playerData.getFloat("XpP")));
            profileData.set(Sharables.FALL_DISTANCE, Float.valueOf((float)playerData.getDouble("fall_distance")));
            profileData.set(Sharables.FIRE_TICKS, Integer.valueOf(playerData.getShort("Fire")));
            profileData.set(Sharables.FOOD_LEVEL, playerData.getInt("foodLevel"));
            profileData.set(Sharables.HEALTH, Double.valueOf(playerData.getFloat("Health")));
            profileData.set(Sharables.INVENTORY, this.extractItems(playerData.getListTag("Inventory", CompoundTag.class), dataVersion, 36));
            profileData.set(Sharables.LEVEL, playerData.getInt("XpLevel"));
            profileData.set(Sharables.OFF_HAND, this.extractItem(equipment.getCompoundTag("offhand"), dataVersion));
            profileData.set(Sharables.REMAINING_AIR, Integer.valueOf(playerData.getShort("Air")));
            profileData.set(Sharables.SATURATION, Float.valueOf(playerData.getFloat("foodSaturationLevel")));
            profileData.set(Sharables.TOTAL_EXPERIENCE, playerData.getInt("XpTotal"));
            return profileData;
        }).onFailure(ex -> {
            InvLogging.warning("Failed to extract player data from %s: %s", path, ex.getMessage());
            ex.printStackTrace();
        });
    }

    private ItemStack[] extractItems(@Nullable ListTag<CompoundTag> inventoryList, int dataVersion, int inventorySize) throws IOException {
        if (inventoryList == null) {
            return new ItemStack[inventorySize];
        }
        ItemStack[] items = new ItemStack[inventorySize];
        for (CompoundTag invData : inventoryList) {
            int slot = invData.getInt("Slot");
            invData.remove("Slot");
            items[slot] = this.extractItem(invData, dataVersion);
        }
        return items;
    }

    @Nullable
    private ItemStack extractItem(@Nullable CompoundTag invData, int dataVersion) throws IOException {
        if (invData == null) {
            return null;
        }
        invData.putInt("DataVersion", dataVersion);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        NBTIO.writer().named().write(gzipOutputStream, (Tag)invData);
        gzipOutputStream.close();
        byteArrayOutputStream.close();
        return (ItemStack)Try.of((CheckedFunction0 & Serializable)() -> ItemStack.deserializeBytes((byte[])byteArrayOutputStream.toByteArray())).onFailure(throwable -> InvLogging.warning("Failed to deserialize item: %s", throwable.getMessage())).getOrNull();
    }
}

