/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.container;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.ProfileCacheManager;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileFileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.util.FutureNow;

public final class ProfileContainer {
    private final String name;
    private final ContainerType type;
    private final ProfileDataSource profileDataSource;
    private final ProfileCacheManager profileCacheManager;

    ProfileContainer(MultiverseInventories inventories, String name, ContainerType type) {
        this.name = name;
        this.type = type;
        this.profileDataSource = (ProfileDataSource)inventories.getServiceLocator().getService(ProfileDataSource.class, new Annotation[0]);
        this.profileCacheManager = (ProfileCacheManager)inventories.getServiceLocator().getService(ProfileCacheManager.class, new Annotation[0]);
    }

    public Collection<String> listPlayerProfileNames() {
        return this.profileDataSource.listPlayerProfileNames(this.getContainerType(), this.getContainerName());
    }

    public ProfileKey getProfileKey(Player player) {
        return this.getProfileKey(ProfileTypes.forPlayer(player), (OfflinePlayer)player);
    }

    public ProfileKey getProfileKey(ProfileType profileType, OfflinePlayer player) {
        return ProfileKey.of(this.getContainerType(), this.getContainerName(), profileType, player);
    }

    public CompletableFuture<PlayerProfile> getPlayerData(Player player) {
        return this.getPlayerData(ProfileTypes.forPlayer(player), (OfflinePlayer)player);
    }

    public CompletableFuture<PlayerProfile> getPlayerData(ProfileType profileType, OfflinePlayer player) {
        return this.profileDataSource.getPlayerProfile(this.getProfileKey(profileType, player));
    }

    public PlayerProfile getPlayerProfileNow(Player player) {
        return this.getPlayerProfileNow(ProfileTypes.forPlayer(player), (OfflinePlayer)player);
    }

    public PlayerProfile getPlayerProfileNow(ProfileType profileType, OfflinePlayer player) {
        return FutureNow.get(this.profileDataSource.getPlayerProfile(ProfileKey.of(this.getContainerType(), this.getContainerName(), profileType, player)));
    }

    public CompletableFuture<Void> deletePlayerFile(OfflinePlayer player) {
        return this.profileDataSource.deletePlayerFile(ProfileFileKey.of(this.type, this.name, player));
    }

    public CompletableFuture<Void> deletePlayerProfile(ProfileType profileType, OfflinePlayer player) {
        return this.profileDataSource.deletePlayerProfile(ProfileKey.of(this.type, this.name, profileType, player));
    }

    public String getContainerName() {
        return this.name;
    }

    public ContainerType getContainerType() {
        return this.type;
    }

    public void clearContainerCache() {
        this.profileCacheManager.clearPlayerProfileCache(key -> key.getContainerType().equals((Object)this.type) && key.getDataName().equals(this.name));
    }
}

