/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.bulkedit;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.handleshare.SingleShareReader;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfileAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfilesPayload;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.data.SingleSharableData;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.util.FutureNow;

final class PlayerProfileDeleteAction
extends PlayerProfileAction {
    private final WorldGroupManager worldGroupManager;
    private final Sharable sharable;

    public PlayerProfileDeleteAction(MultiverseInventories inventories, Sharable sharable, PlayerProfilesPayload bulkProfilesPayload) {
        super(inventories, bulkProfilesPayload);
        this.worldGroupManager = (WorldGroupManager)inventories.getServiceLocator().getService(WorldGroupManager.class, new Annotation[0]);
        this.sharable = sharable;
    }

    @Override
    protected CompletableFuture<Void> performAction(ProfileKey key) {
        return ((CompletableFuture)this.profileDataSource.getPlayerProfile(key).thenCompose(playerProfile -> {
            playerProfile.set(this.sharable, null);
            return this.profileDataSource.updatePlayerProfile((PlayerProfile)playerProfile);
        })).thenCompose(ignore -> this.profileDataSource.modifyGlobalProfile(key, profile -> profile.setLoadOnLogin(true)));
    }

    @Override
    protected boolean isOnlinePlayerAffected(ProfileKey key, Player player) {
        if (!ProfileTypes.forPlayer(player).equals(key.getProfileType())) {
            return false;
        }
        List<WorldGroup> groups = this.worldGroupManager.getGroupsForWorld(player.getWorld().getName()).stream().filter(group -> group.isSharing(this.sharable)).toList();
        if (groups.isEmpty()) {
            return key.getContainerType() == ContainerType.WORLD && player.getWorld().getName().equals(key.getDataName());
        }
        return key.getContainerType() == ContainerType.GROUP && groups.stream().anyMatch(group -> group.getName().equals(key.getDataName()));
    }

    @Override
    protected void updateOnlinePlayerNow(Player player) {
        SingleSharableData sharableData = new SingleSharableData(this.sharable, FutureNow.get(SingleShareReader.of(this.inventories, player, this.sharable).read()));
        this.sharable.getHandler().updatePlayer(player, sharableData);
    }
}

