/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile;

import java.io.File;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.annotation.PreDestroy;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Service
final class AsyncFileIO {
    private final ExecutorService fileIOExecutorService = Executors.newWorkStealingPool();
    private final Map<File, CountDownLatch> fileLocks = new ConcurrentHashMap<File, CountDownLatch>();

    AsyncFileIO() {
    }

    CompletableFuture<Void> queueAction(Runnable action) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.fileIOExecutorService.submit(() -> Try.runRunnable((Runnable)action).onFailure(future::completeExceptionally).onSuccess(ignore -> future.complete(null)));
        return future;
    }

    <T> CompletableFuture<T> queueCallable(Supplier<T> supplier) {
        CompletableFuture future = new CompletableFuture();
        this.fileIOExecutorService.submit(() -> Try.ofSupplier((Supplier)supplier).onFailure(future::completeExceptionally).onSuccess(future::complete));
        return future;
    }

    CompletableFuture<Void> queueFilesAction(File[] files, Runnable action) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.fileIOExecutorService.submit(() -> {
            for (File file : files) {
                CountDownLatch toWaitLatch = this.fileLocks.put(file, new CountDownLatch(1));
                this.waitForLock(file, toWaitLatch);
            }
            Try tryResult = Try.runRunnable((Runnable)action);
            for (File file : files) {
                CountDownLatch thisLatch = this.fileLocks.remove(file);
                if (thisLatch == null) continue;
                thisLatch.countDown();
            }
            tryResult.onFailure(future::completeExceptionally).onSuccess(ignore -> future.complete(null));
        });
        return future;
    }

    CompletableFuture<Void> queueFileAction(File file, Runnable action) {
        CountDownLatch thisLatch = new CountDownLatch(1);
        CountDownLatch toWaitLatch = this.fileLocks.put(file, thisLatch);
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.fileIOExecutorService.submit(() -> {
            this.waitForLock(file, toWaitLatch);
            Try tryResult = Try.runRunnable((Runnable)action);
            this.fileLocks.remove(file);
            thisLatch.countDown();
            tryResult.onFailure(future::completeExceptionally).onSuccess(ignore -> future.complete(null));
        });
        return future;
    }

    <T> CompletableFuture<T> queueFileCallable(File file, Supplier<T> supplier) {
        CountDownLatch thisLatch = new CountDownLatch(1);
        CountDownLatch toWaitLatch = this.fileLocks.put(file, thisLatch);
        CompletableFuture future = new CompletableFuture();
        this.fileIOExecutorService.submit(() -> {
            this.waitForLock(file, toWaitLatch);
            Try tryResult = Try.ofSupplier((Supplier)supplier);
            this.fileLocks.remove(file);
            thisLatch.countDown();
            tryResult.onFailure(future::completeExceptionally).onSuccess(future::complete);
        });
        return future;
    }

    private void waitForLock(File file, CountDownLatch toWaitLatch) {
        if (toWaitLatch != null && toWaitLatch.getCount() > 0L) {
            try {
                InvLogging.finest("Waiting for lock on " + String.valueOf(file), new Object[0]);
                toWaitLatch.await(10L, TimeUnit.SECONDS);
                InvLogging.finest("Aquired lock on " + String.valueOf(file), new Object[0]);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    ExecutorService getExecutor() {
        return this.fileIOExecutorService;
    }

    @PreDestroy
    private void completeRemainingTaskAndShutdown() {
        this.fileIOExecutorService.shutdown();
        try {
            if (!this.fileIOExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.fileIOExecutorService.shutdownNow();
                if (!this.fileIOExecutorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    InvLogging.severe("File IO executor did not terminate", new Object[0]);
                }
            }
        }
        catch (InterruptedException ie) {
            this.fileIOExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

