/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.listeners;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.api.Subscribe;
import github.scarsz.discordsrv.api.events.AchievementMessagePreProcessEvent;
import net.kyori.adventure.text.Component;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

final class AdvancementDonePaperHelper {
    private static AdvancementDonePaperHelper instance;

    static AdvancementDonePaperHelper getInstance() {
        if (instance == null) {
            instance = new AdvancementDonePaperHelper();
        }
        return instance;
    }

    private AdvancementDonePaperHelper() {
    }

    void registerDiscordSrvHook() {
        InvLogging.fine("Registering DiscordSRV advancement grant hook.", new Object[0]);
        DiscordSRV.api.subscribe((Object)new DiscordSrvHook());
    }

    void handleAdvancementDoneEventSuppression(PlayerAdvancementDoneEvent event) {
        InvLogging.finest("Suppressing advancement done message for player %s due to share handling.", event.getPlayer().getName());
        event.message((Component)Component.text((String)"mvinv:suppressed"));
    }

    private static class DiscordSrvHook {
        private DiscordSrvHook() {
        }

        @Subscribe
        public void onAchievementMessage(AchievementMessagePreProcessEvent event) {
            Event event2 = event.getTriggeringBukkitEvent();
            if (!(event2 instanceof PlayerAdvancementDoneEvent)) {
                return;
            }
            PlayerAdvancementDoneEvent advancementEvent = (PlayerAdvancementDoneEvent)event2;
            if (Component.EQUALS.test(advancementEvent.message(), Component.text((String)"mvinv:suppressed"))) {
                InvLogging.finest("Suppressing DiscordSRV advancement message for player %s due to share handling.", advancementEvent.getPlayer().getName());
                event.setCancelled(true);
            }
        }
    }
}

