/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.handleshare;

import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class SingleShareWriter<T> {
    private final MultiverseInventories inventories;
    private final OfflinePlayer player;
    private final String worldName;
    private final ProfileType profileType;
    private final Sharable<T> sharable;
    private final ProfileDataSource profileDataSource;

    public static <T> SingleShareWriter<T> of(MultiverseInventories inventories, Player player, Sharable<T> sharable) {
        return new SingleShareWriter<T>(inventories, (OfflinePlayer)player, player.getWorld().getName(), ProfileTypes.forPlayer(player), sharable);
    }

    public static <T> SingleShareWriter<T> of(MultiverseInventories inventories, OfflinePlayer player, String worldName, ProfileType profileType, Sharable<T> sharable) {
        return new SingleShareWriter<T>(inventories, player, worldName, profileType, sharable);
    }

    private SingleShareWriter(MultiverseInventories inventories, OfflinePlayer player, String worldName, ProfileType profileType, Sharable<T> sharable) {
        this.inventories = inventories;
        this.player = player;
        this.worldName = worldName;
        this.profileType = profileType;
        this.sharable = sharable;
        this.profileDataSource = (ProfileDataSource)inventories.getServiceLocator().getService(ProfileDataSource.class, new Annotation[0]);
    }

    public void write(T value) {
        this.write(value, false);
    }

    public CompletableFuture<Void> write(T value, boolean save) {
        if (this.sharable.isOptional() && !((InventoriesConfig)this.inventories.getServiceLocator().getService(InventoriesConfig.class, new Annotation[0])).getActiveOptionalShares().contains(this.sharable)) {
            InvLogging.finer("Skipping write for optional share: " + String.valueOf(this.sharable), new Object[0]);
            return CompletableFuture.completedFuture(null);
        }
        InvLogging.finer("Writing single share: " + this.sharable.getNames()[0], new Object[0]);
        ProfileContainerStoreProvider profileContainerStoreProvider = (ProfileContainerStoreProvider)this.inventories.getServiceLocator().getService(ProfileContainerStoreProvider.class, new Annotation[0]);
        profileContainerStoreProvider.getStore(ContainerType.WORLD).getContainer(this.worldName).getPlayerData(this.profileType, this.player).thenAccept(profile -> this.writeNewValueToProfile((PlayerProfile)profile, value, save));
        return CompletableFuture.allOf((CompletableFuture[])((WorldGroupManager)this.inventories.getServiceLocator().getService(WorldGroupManager.class, new Annotation[0])).getGroupsForWorld(this.worldName).stream().map(worldGroup -> {
            if (!worldGroup.getApplicableShares().contains(this.sharable)) {
                return CompletableFuture.completedFuture(null);
            }
            return worldGroup.getGroupProfileContainer().getPlayerData(this.profileType, this.player).thenCompose(profile -> this.writeNewValueToProfile((PlayerProfile)profile, value, save));
        }).toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<Void> writeNewValueToProfile(PlayerProfile profile, T value, boolean save) {
        if (Objects.equals(profile.get(this.sharable), value)) {
            return CompletableFuture.completedFuture(null);
        }
        InvLogging.finest("Writing %s value: %s for profile %s", this.sharable, value, profile);
        profile.set(this.sharable, value);
        if (save) {
            return this.profileDataSource.updatePlayerProfile(profile);
        }
        return CompletableFuture.completedFuture(null);
    }
}

