/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.handleshare;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.handleshare.PersistingProfile;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.data.ProfileData;
import org.mvplugins.multiverse.inventories.share.Sharable;
import org.mvplugins.multiverse.inventories.util.FutureNow;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class ShareHandlingUpdater {
    private final Player player;
    private final PersistingProfile profile;
    private final ProfileDataSource profileDataSource;

    public static CompletableFuture<Void> updateProfile(MultiverseInventories inventories, Player player, PersistingProfile profile) {
        return new ShareHandlingUpdater(inventories, player, profile).updateProfile();
    }

    public static void updatePlayer(MultiverseInventories inventories, Player player, PersistingProfile profile) {
        new ShareHandlingUpdater(inventories, player, profile).updatePlayer();
    }

    private ShareHandlingUpdater(MultiverseInventories inventories, Player player, PersistingProfile profile) {
        this.player = player;
        this.profile = profile;
        this.profileDataSource = (ProfileDataSource)inventories.getServiceLocator().getService(ProfileDataSource.class, new Annotation[0]);
    }

    private CompletableFuture<Void> updateProfile() {
        if (this.profile.getShares().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.profileDataSource.getPlayerProfile(this.profile.getProfileKey()).thenCompose(playerProfile -> {
            for (Sharable sharable : this.profile.getShares()) {
                sharable.getHandler().updateProfile((ProfileData)playerProfile, this.player);
            }
            InvLogging.finer("Persisted: " + String.valueOf(this.profile.getShares()) + " to " + String.valueOf((Object)playerProfile.getContainerType()) + ":" + playerProfile.getContainerName() + " (" + String.valueOf(playerProfile.getProfileType()) + ") for player " + playerProfile.getPlayerName(), new Object[0]);
            return this.profileDataSource.updatePlayerProfile((PlayerProfile)playerProfile);
        })).exceptionally(throwable -> {
            InvLogging.severe("Could not persist profile for player: %s. %s", this.player.getName(), throwable.getMessage());
            return null;
        });
    }

    private void updatePlayer() {
        if (this.profile.getShares().isEmpty()) {
            return;
        }
        this.player.closeInventory();
        Try.of((CheckedFunction0 & Serializable)() -> FutureNow.get(this.profileDataSource.getPlayerProfile(this.profile.getProfileKey()))).peek(playerProfile -> {
            ArrayList<Sharable> loaded = new ArrayList<Sharable>(this.profile.getShares().size());
            ArrayList<Sharable> defaulted = new ArrayList<Sharable>(this.profile.getShares().size());
            for (Sharable sharable : this.profile.getShares()) {
                if (sharable.getHandler().updatePlayer(this.player, (ProfileData)playerProfile)) {
                    loaded.add(sharable);
                    continue;
                }
                defaulted.add(sharable);
            }
            if (!loaded.isEmpty()) {
                InvLogging.finer("Updated: " + String.valueOf(loaded) + " for " + playerProfile.getPlayerName() + " for " + String.valueOf((Object)playerProfile.getContainerType()) + ":" + playerProfile.getContainerName() + " (" + String.valueOf(playerProfile.getProfileType()) + ")", new Object[0]);
            }
            if (!defaulted.isEmpty()) {
                InvLogging.finer("Defaulted: " + String.valueOf(defaulted) + " for " + playerProfile.getPlayerName() + " for " + String.valueOf((Object)playerProfile.getContainerType()) + ":" + playerProfile.getContainerName() + " (" + String.valueOf(playerProfile.getProfileType()) + ")", new Object[0]);
            }
        }).onFailure(e -> InvLogging.severe("Error getting playerdata: " + e.getMessage(), new Object[0]));
    }
}

