/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.handleshare;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.handleshare.AffectedProfiles;
import org.mvplugins.multiverse.inventories.share.Sharable;

@Service
@ApiStatus.AvailableSince(value="5.3")
public final class PlayerShareHandlingState {
    private final Map<UUID, AffectedProfiles> playerAffectedProfiles = new ConcurrentHashMap<UUID, AffectedProfiles>();

    @Inject
    PlayerShareHandlingState() {
    }

    void setPlayerAffectedProfiles(Player player, AffectedProfiles status) {
        this.playerAffectedProfiles.put(player.getUniqueId(), status);
    }

    void removePlayerAffectedProfiles(Player player) {
        this.playerAffectedProfiles.remove(player.getUniqueId());
    }

    @ApiStatus.AvailableSince(value="5.3")
    public boolean isHandlingSharable(Player player, Sharable<?> sharable) {
        AffectedProfiles status = this.playerAffectedProfiles.get(player.getUniqueId());
        return status != null && status.isShareToRead(sharable);
    }
}

