/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.bulkedit.playerprofile;

import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.bulkedit.BulkEditCommand;
import org.mvplugins.multiverse.inventories.commands.bulkedit.playerprofile.IncludeGroupsWorldsFlag;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditCreator;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfilesPayload;
import org.mvplugins.multiverse.inventories.profile.key.ContainerKey;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;

@Service
final class ClearCommand
extends BulkEditCommand {
    private final CommandQueueManager commandQueueManager;
    private final IncludeGroupsWorldsFlag flags;

    @Inject
    ClearCommand(@NotNull BulkEditCreator bulkEditCreator, @NotNull CommandQueueManager commandQueueManager, @NotNull IncludeGroupsWorldsFlag flags) {
        super(bulkEditCreator);
        this.commandQueueManager = commandQueueManager;
        this.flags = flags;
    }

    @Subcommand(value="bulkedit playerprofile clear")
    @CommandPermission(value="multiverse.inventories.bulkedit")
    @CommandCompletion(value="@mvinvplayernames @mvinvcontainerkeys @mvinvprofiletypes:multiple @flags:groupName=mvinvincludegroupsworlds")
    @Syntax(value="<players> <groups/worlds> [profile-type] [--include-groups-worlds]")
    void onCommand(MVCommandIssuer issuer, @Syntax(value="<players>") GlobalProfileKey[] globalProfileKeys, @Syntax(value="<groups/worlds>") ContainerKey[] containerKeys, @Syntax(value="[profile-types]") ProfileType[] profileTypes, @Syntax(value="[--include-groups-worlds]") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        BulkEditAction<?> bulkEditAction = this.bulkEditCreator.playerProfileClear(new PlayerProfilesPayload(globalProfileKeys, containerKeys, profileTypes, parsedFlags.hasFlag(this.flags.includeGroupsWorlds)));
        this.outputActionSummary(issuer, bulkEditAction);
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer((MVCommandIssuer)issuer).prompt(Message.of((String)"Are you sure you want to clear the selected profiles?", (MessageReplacement[])new MessageReplacement[0])).action(() -> this.runBulkEditAction(issuer, bulkEditAction)));
    }
}

