/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.plugin.Plugin;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.LegacyAliasCommand;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandAlias;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.commands.prompts.GroupControlPrompt;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
class GroupCommand
extends InventoriesCommand {
    private final MultiverseInventories plugin;

    @Inject
    GroupCommand(@NotNull MultiverseInventories plugin) {
        this.plugin = plugin;
    }

    @Subcommand(value="group")
    @CommandPermission(value="multiverse.inventories.group")
    @Description(value="Manage a world group with prompts!")
    void onGroupCommand(@NotNull MVCommandIssuer issuer) {
        CommandSender commandSender = issuer.getIssuer();
        if (!(commandSender instanceof Conversable)) {
            issuer.sendError((MessageKeyProvider)MVInvi18n.GROUP_NONCONVERSABLE);
            return;
        }
        Conversable conversable = (Conversable)commandSender;
        Conversation conversation = new ConversationFactory((Plugin)this.plugin).withFirstPrompt((Prompt)new GroupControlPrompt(this.plugin, issuer)).withEscapeSequence("##").withModality(false).buildConversation(conversable);
        conversation.begin();
    }

    @Service
    private static final class LegacyAlias
    extends GroupCommand
    implements LegacyAliasCommand {
        @Inject
        LegacyAlias(MultiverseInventories plugin) {
            super(plugin);
        }

        @Override
        @CommandAlias(value="mvinvgroup|mvinvg")
        void onGroupCommand(MVCommandIssuer issuer) {
            super.onGroupCommand(issuer);
        }
    }
}

