/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.exceptions.MultiverseException;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Optional;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;

@Service
final class ConfigCommand
extends InventoriesCommand {
    private final InventoriesConfig config;

    @Inject
    ConfigCommand(@NotNull InventoriesConfig config) {
        this.config = config;
    }

    @Subcommand(value="config")
    @CommandPermission(value="multiverse.inventories.config")
    @CommandCompletion(value="@mvinvconfigs @mvinvconfigvalues")
    @Syntax(value="<name> [value]")
    @Description(value="Show or set a config value.")
    void onConfigCommand(MVCommandIssuer issuer, @Syntax(value="<name>") @Description(value="The name of the config to set or show.") String name, @Optional @Syntax(value="[value]") @Description(value="The value to set the config to. If not specified, the current value will be shown.") String value) {
        if (value == null) {
            this.showConfigValue(issuer, name);
            return;
        }
        this.updateConfigValue(issuer, name, value);
    }

    private void showConfigValue(MVCommandIssuer issuer, String name) {
        this.config.getStringPropertyHandle().getProperty(name).onSuccess(value -> issuer.sendMessage(name + "is currently set to " + String.valueOf(value))).onFailure(e -> issuer.sendMessage(e.getMessage()));
    }

    private void updateConfigValue(MVCommandIssuer issuer, String name, String value) {
        this.config.getStringPropertyHandle().setPropertyString(name, value).onSuccess(ignore -> {
            this.config.save();
            issuer.sendMessage("Successfully set " + name + " to " + value);
        }).onFailure(ignore -> issuer.sendMessage("Unable to set " + name + " to " + value + ".")).onFailure(MultiverseException.class, e -> Option.of((Object)e.getLocalizableMessage()).peek(arg_0 -> ((MVCommandIssuer)issuer).sendError(arg_0)));
    }
}

