/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import java.util.Arrays;
import java.util.List;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.CommandFlag;
import org.mvplugins.multiverse.core.command.flag.CommandFlagsManager;
import org.mvplugins.multiverse.core.command.flag.FlagBuilder;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.utils.REPatterns;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.util.GroupWorldNameValidator;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
final class AddWorldsCommand
extends InventoriesCommand {
    private final WorldGroupManager worldGroupManager;
    private final GroupWorldNameValidator groupWorldNameValidator;
    private final Flags flags;

    @Inject
    AddWorldsCommand(@NotNull WorldGroupManager worldGroupManager, @NotNull GroupWorldNameValidator groupWorldNameValidator, @NotNull Flags flags) {
        this.worldGroupManager = worldGroupManager;
        this.groupWorldNameValidator = groupWorldNameValidator;
        this.flags = flags;
    }

    @Subcommand(value="add-worlds")
    @CommandPermission(value="multiverse.inventories.addworlds")
    @CommandCompletion(value="@worldGroups @mvworlds:multiple,scope=both, @flags:groupName=mvinvaddworlds")
    @Syntax(value="<group> <world[,extra]> [--skip-exist-check]")
    @Description(value="Adds a World to a World Group.")
    void onAddWorldCommand(MVCommandIssuer issuer, @Syntax(value="<group>") @Description(value="Group you want to add the world to.") WorldGroup group, @Syntax(value="<world>") @Description(value="World name to add.") String worlds, @Syntax(value="[--skip-exist-check]") String[] flagArray) {
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        List<String> worldNames = Arrays.stream(REPatterns.COMMA.split(worlds)).map(String::toLowerCase).toList();
        if (!parsedFlags.hasFlag(this.flags.skipExistCheck)) {
            for (String worldName : worldNames) {
                if (this.groupWorldNameValidator.validateWorldName(worldName)) continue;
                issuer.sendError((MessageKeyProvider)MVInvi18n.ERROR_NOWORLD, new MessageReplacement[]{MessageReplacement.replace((String)"{world}").with((Object)worldName)});
                return;
            }
        }
        String worldNamesString = String.join((CharSequence)", ", worldNames);
        if (!group.getConfigWorlds().addAll(worldNames)) {
            issuer.sendError((MessageKeyProvider)MVInvi18n.ADDWORLD_WORLDALREADYEXISTS, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName()), MessageReplacement.replace((String)"{world}").with((Object)worldNamesString)});
            return;
        }
        this.worldGroupManager.updateGroup(group);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.ADDWORLD_WORLDADDED, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName()), MessageReplacement.replace((String)"{world}").with((Object)worldNamesString)});
        this.worldGroupManager.checkForConflicts().sendConflictIssue(issuer);
    }

    @Service
    private static final class Flags
    extends FlagBuilder {
        private static final String NAME = "mvinvaddworlds";
        private final CommandFlag skipExistCheck = this.flag(CommandFlag.builder((String)"--skip-exist-check").addAlias(new String[]{"-s"}).build());

        @Inject
        private Flags(@NotNull CommandFlagsManager flagsManager) {
            super(NAME, flagsManager);
        }
    }
}

