/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.util;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.type.Bed;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.core.world.location.UnloadedWorldLocation;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;

@SerializableAs(value="RespawnLocation")
@ApiStatus.AvailableSince(value="5.2")
public class RespawnLocation
extends UnloadedWorldLocation {
    @NotNull
    private RespawnLocationType respawnType;

    public RespawnLocation(@Nullable String worldName, double x, double y, double z, @NotNull RespawnLocationType respawnType) {
        super(worldName, x, y, z);
        this.respawnType = respawnType;
    }

    public RespawnLocation(@Nullable String worldName, double x, double y, double z, float yaw, float pitch, @NotNull RespawnLocationType respawnType) {
        super(worldName, x, y, z, yaw, pitch);
        this.respawnType = respawnType;
    }

    public RespawnLocation(@Nullable World world, double x, double y, double z, @NotNull RespawnLocationType respawnType) {
        super(world, x, y, z);
        this.respawnType = respawnType;
    }

    public RespawnLocation(@Nullable World world, double x, double y, double z, float yaw, float pitch, @NotNull RespawnLocationType respawnType) {
        super(world, x, y, z, yaw, pitch);
        this.respawnType = respawnType;
    }

    public RespawnLocation(@NotNull Location location, @NotNull RespawnLocationType respawnType) {
        this(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), respawnType);
    }

    @NotNull
    public Map<String, Object> serialize() {
        Map data = super.serialize();
        data.put("respawnType", this.respawnType.name());
        return data;
    }

    @NotNull
    public static Location deserialize(@NotNull Map<String, Object> args) {
        return new RespawnLocation(args.containsKey("world") ? args.get("world").toString() : null, NumberConversions.toDouble((Object)args.get("x")), NumberConversions.toDouble((Object)args.get("y")), NumberConversions.toDouble((Object)args.get("z")), NumberConversions.toFloat((Object)args.get("yaw")), NumberConversions.toFloat((Object)args.get("pitch")), args.containsKey("respawnType") ? (RespawnLocationType)((Object)Try.of((CheckedFunction0 & Serializable)() -> RespawnLocationType.valueOf(String.valueOf(args.get("respawnType")).toUpperCase(Locale.ROOT))).getOrElse((Object)RespawnLocationType.UNKNOWN)) : RespawnLocationType.UNKNOWN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Location)) return false;
        Location other = (Location)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (!(other instanceof RespawnLocation)) return true;
        RespawnLocation otherRespawnLocation = (RespawnLocation)other;
        if (this.respawnType != otherRespawnLocation.respawnType) return false;
        return true;
    }

    public int hashCode() {
        return 19 * super.hashCode() + this.respawnType.hashCode();
    }

    public String toString() {
        return "RespawnLocation{world=" + this.getWorldName() + ",x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",pitch=" + this.getPitch() + ",yaw=" + this.getYaw() + ",respawnType=" + String.valueOf((Object)this.respawnType) + "}";
    }

    @ApiStatus.AvailableSince(value="5.2")
    public boolean isValidRespawnLocation() {
        World world = this.getWorld();
        if (world == null) {
            return false;
        }
        switch (this.respawnType.ordinal()) {
            case 0: {
                return world.getBlockAt((Location)this).getBlockData() instanceof Bed;
            }
            case 1: {
                return world.getBlockAt((Location)this).getType() == Material.RESPAWN_ANCHOR;
            }
        }
        return true;
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public RespawnLocationType getRespawnType() {
        return this.respawnType;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public void setRespawnType(@NotNull RespawnLocationType respawnType) {
        this.respawnType = respawnType;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public static enum RespawnLocationType {
        BED,
        ANCHOR,
        UNKNOWN;

    }
}

