/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.util;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

public final class FutureNow {
    private static final long TIMEOUT = TimeUnit.SECONDS.toNanos(10L);

    public static <T> T get(CompletableFuture<T> future) {
        try {
            return future.get(TIMEOUT, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            InvLogging.severe("Could not get future as it timed out: " + String.valueOf(future), new Object[0]);
            throw new RuntimeException(e);
        }
    }
}

