/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.share;

import java.util.Map;
import org.bukkit.Location;
import org.mvplugins.multiverse.core.world.location.UnloadedWorldLocation;
import org.mvplugins.multiverse.inventories.share.SharableSerializer;
import org.mvplugins.multiverse.inventories.util.LegacyParsers;
import org.mvplugins.multiverse.inventories.util.RespawnLocation;

abstract class LocationSerializer
implements SharableSerializer<Location> {
    LocationSerializer() {
    }

    @Override
    public Location deserialize(Object obj) {
        if (obj instanceof Location) {
            return (Location)obj;
        }
        if (obj instanceof String) {
            return LegacyParsers.parseLocation(obj.toString());
        }
        if (obj instanceof Map) {
            return LegacyParsers.parseLocation((Map)obj);
        }
        return LegacyParsers.parseLocation(obj.toString());
    }

    public abstract Location serialize(Location var1);

    static final class RespawnLocationSerializer
    extends LocationSerializer {
        RespawnLocationSerializer() {
        }

        @Override
        public Location serialize(Location loc) {
            if (loc != null && !(loc instanceof RespawnLocation)) {
                return new RespawnLocation(loc, RespawnLocation.RespawnLocationType.UNKNOWN);
            }
            return loc;
        }
    }

    static final class UnloadedWorldLocationSerializer
    extends LocationSerializer {
        UnloadedWorldLocationSerializer() {
        }

        @Override
        public Location serialize(Location loc) {
            if (loc != null && !(loc instanceof UnloadedWorldLocation)) {
                return new UnloadedWorldLocation(loc);
            }
            return loc;
        }
    }
}

