/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.bulkedit;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.GlobalProfileClearAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfileClearAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfileClonePlayerAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfileCloneWorldGroupAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfileDeleteAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfilesPayload;
import org.mvplugins.multiverse.inventories.profile.key.ContainerKey;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.share.Sharable;

@Service
@ApiStatus.Experimental
public final class BulkEditCreator {
    private final MultiverseInventories inventories;

    @Inject
    BulkEditCreator(@NotNull MultiverseInventories inventories) {
        this.inventories = inventories;
    }

    public BulkEditAction<?> globalProfileClear(GlobalProfileKey[] globalProfileKeys, boolean clearPlayerProfiles) {
        return new GlobalProfileClearAction(this.inventories, globalProfileKeys, clearPlayerProfiles);
    }

    @ApiStatus.AvailableSince(value="5.3")
    public BulkEditAction<?> playerProfileCloneWorldGroup(ContainerKey fromContainerKey, PlayerProfilesPayload toProfiles) {
        return new PlayerProfileCloneWorldGroupAction(this.inventories, toProfiles, fromContainerKey);
    }

    @ApiStatus.AvailableSince(value="5.3")
    public BulkEditAction<?> playerProfileClonePlayer(GlobalProfileKey fromPlayer, PlayerProfilesPayload toProfiles) {
        return new PlayerProfileClonePlayerAction(this.inventories, toProfiles, fromPlayer);
    }

    public BulkEditAction<?> playerProfileClear(PlayerProfilesPayload bulkProfilesPayload) {
        return new PlayerProfileClearAction(this.inventories, bulkProfilesPayload);
    }

    public BulkEditAction<?> playerProfileDeleteSharable(PlayerProfilesPayload bulkProfilesPayload, Sharable<?> sharable) {
        return new PlayerProfileDeleteAction(this.inventories, sharable, bulkProfilesPayload);
    }
}

