/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.vavr.control.Option;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.profile.AsyncFileIO;
import org.mvplugins.multiverse.inventories.profile.GlobalProfile;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.key.ProfileFileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.utils.benmanes.caffeine.cache.AsyncCache;
import org.mvplugins.multiverse.inventories.utils.benmanes.caffeine.cache.Cache;
import org.mvplugins.multiverse.inventories.utils.benmanes.caffeine.cache.Caffeine;
import org.mvplugins.multiverse.inventories.utils.benmanes.caffeine.cache.stats.CacheStats;

@Service
public final class ProfileCacheManager {
    private final Cache<ProfileFileKey, FileConfiguration> playerFileCache;
    private final AsyncCache<ProfileKey, PlayerProfile> playerProfileCache;
    private final AsyncCache<UUID, GlobalProfile> globalProfileCache;

    @Inject
    ProfileCacheManager(@NotNull InventoriesConfig inventoriesConfig, @NotNull AsyncFileIO asyncFileIO) {
        this.playerFileCache = Caffeine.newBuilder().expireAfterAccess(inventoriesConfig.getPlayerFileCacheExpiry(), TimeUnit.MINUTES).maximumSize(inventoriesConfig.getPlayerFileCacheSize()).recordStats().build();
        this.playerProfileCache = Caffeine.newBuilder().expireAfterAccess(inventoriesConfig.getPlayerProfileCacheExpiry(), TimeUnit.MINUTES).maximumSize(inventoriesConfig.getPlayerProfileCacheSize()).executor(asyncFileIO.getExecutor()).recordStats().buildAsync();
        this.globalProfileCache = Caffeine.newBuilder().expireAfterAccess(inventoriesConfig.getGlobalProfileCacheExpiry(), TimeUnit.MINUTES).maximumSize(inventoriesConfig.getGlobalProfileCacheSize()).executor(asyncFileIO.getExecutor()).recordStats().buildAsync();
    }

    FileConfiguration getOrLoadPlayerFile(ProfileFileKey key, Function<ProfileFileKey, FileConfiguration> mappingFunction) {
        return this.playerFileCache.get(ProfileFileKey.copyOf(key), mappingFunction);
    }

    CompletableFuture<PlayerProfile> getOrLoadPlayerProfile(ProfileKey key, BiFunction<ProfileKey, ? super Executor, ? extends CompletableFuture<PlayerProfile>> mappingFunction) {
        return this.playerProfileCache.get(key, mappingFunction);
    }

    CompletableFuture<GlobalProfile> getOrLoadGlobalProfile(UUID uuid, BiFunction<UUID, ? super Executor, ? extends CompletableFuture<GlobalProfile>> mappingFunction) {
        return this.globalProfileCache.get(uuid, mappingFunction);
    }

    Option<PlayerProfile> getCachedPlayerProfile(ProfileKey key) {
        return Option.of((Object)this.playerProfileCache.synchronous().getIfPresent(key));
    }

    void clearCacheForProfile(ProfileKey profileKey) {
        this.playerFileCache.invalidate(profileKey);
        this.playerProfileCache.synchronous().invalidate(profileKey);
    }

    void clearCacheForFile(ProfileFileKey profileKey) {
        ProfileFileKey profileFileKeyCopy = ProfileFileKey.copyOf(profileKey);
        this.playerFileCache.invalidate(profileFileKeyCopy);
        for (ProfileType profileType : ProfileTypes.getTypes()) {
            this.playerProfileCache.synchronous().invalidate(profileFileKeyCopy.forProfileType(profileType));
        }
    }

    void clearProfileFileCache(Predicate<ProfileFileKey> predicate) {
        this.playerFileCache.invalidateAll(Sets.filter(this.playerFileCache.asMap().keySet(), predicate::test));
        this.playerProfileCache.synchronous().invalidateAll(Sets.filter(this.playerProfileCache.asMap().keySet(), predicate::test));
    }

    public void clearPlayerCache(String playerName) {
        this.clearPlayerProfileCache(key -> key.getPlayerName().equals(playerName));
    }

    public void clearPlayerCache(UUID playerUUID) {
        this.clearPlayerProfileCache(key -> key.getPlayerUUID().equals(playerUUID));
        this.clearGlobalProfileCache(key -> key.equals(playerUUID));
    }

    public void clearPlayerProfileCache(Predicate<ProfileKey> predicate) {
        this.playerFileCache.invalidateAll(Sets.filter(this.playerFileCache.asMap().keySet(), key -> predicate.test(key.forProfileType(null))));
        this.playerProfileCache.synchronous().invalidateAll(Sets.filter(this.playerProfileCache.asMap().keySet(), predicate::test));
    }

    public void clearAllPlayerProfileCaches() {
        this.playerFileCache.invalidateAll();
        this.playerProfileCache.synchronous().invalidateAll();
    }

    public void clearGlobalProfileCache(Predicate<UUID> predicate) {
        this.globalProfileCache.synchronous().invalidateAll(Sets.filter(this.globalProfileCache.asMap().keySet(), predicate::test));
    }

    public void clearAllGlobalProfileCaches() {
        this.globalProfileCache.synchronous().invalidateAll();
    }

    public void clearAllCache() {
        this.playerFileCache.invalidateAll();
        this.globalProfileCache.synchronous().invalidateAll();
        this.playerProfileCache.synchronous().invalidateAll();
    }

    public Map<String, CacheStats> getCacheStats() {
        HashMap<String, CacheStats> stats = new HashMap<String, CacheStats>();
        stats.put("playerFileCache", this.playerFileCache.stats());
        stats.put("globalProfileCache", this.globalProfileCache.synchronous().stats());
        stats.put("profileCache", this.playerProfileCache.synchronous().stats());
        return stats;
    }
}

