/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.listeners;

import java.util.Arrays;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.DefaultEventPriority;
import org.mvplugins.multiverse.core.dynamiclistener.annotations.EventMethod;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.listeners.MVInvListener;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;
import org.mvplugins.multiverse.inventories.utils.InvLogging;
import org.mvplugins.multiverse.inventories.view.InventoryDataProvider;
import org.mvplugins.multiverse.inventories.view.InventoryGUIHelper;
import org.mvplugins.multiverse.inventories.view.ModifiableInventoryHolder;
import org.mvplugins.multiverse.inventories.view.ReadOnlyInventoryHolder;

@Service
final class InventoryViewListener
implements MVInvListener {
    private final MultiverseInventories inventories;
    private final InventoryDataProvider inventoryDataProvider;
    private final InventoryGUIHelper inventoryGUIHelper;

    @Inject
    InventoryViewListener(@NotNull MultiverseInventories inventories, @NotNull InventoryDataProvider inventoryDataProvider, @NotNull InventoryGUIHelper inventoryGUIHelper) {
        this.inventories = inventories;
        this.inventoryDataProvider = inventoryDataProvider;
        this.inventoryGUIHelper = inventoryGUIHelper;
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.NORMAL)
    void onInventoryClick(InventoryClickEvent event) {
        boolean currentItemIsFiller;
        boolean isPaddingSlot;
        if (event.getInventory().getHolder() instanceof ReadOnlyInventoryHolder || event.getClickedInventory() != null && event.getClickedInventory().getHolder() instanceof ReadOnlyInventoryHolder) {
            event.setCancelled(true);
            return;
        }
        if (!(event.getInventory().getHolder() instanceof ModifiableInventoryHolder)) {
            return;
        }
        int clickedSlot = event.getRawSlot();
        ItemStack cursorItem = event.getCursor();
        ItemStack currentItem = event.getCurrentItem();
        Player player = (Player)event.getWhoClicked();
        boolean isSpecialSlot = clickedSlot >= 36 && clickedSlot <= 40;
        boolean bl = isPaddingSlot = clickedSlot >= 41 && clickedSlot <= 44;
        if (isPaddingSlot) {
            event.setCancelled(true);
            return;
        }
        if (!isSpecialSlot) {
            return;
        }
        boolean bl2 = currentItemIsFiller = currentItem != null && this.inventoryGUIHelper.isFillerItem(currentItem);
        if (currentItemIsFiller && (cursorItem == null || cursorItem.getType() == Material.AIR)) {
            event.setCancelled(true);
            return;
        }
        if (cursorItem != null && cursorItem.getType() != Material.AIR && !this.inventoryGUIHelper.isValidItemForSlot(cursorItem, clickedSlot)) {
            event.setCancelled(true);
            return;
        }
        if (cursorItem != null && cursorItem.getType() != Material.AIR && this.inventoryGUIHelper.isValidItemForSlot(cursorItem, clickedSlot)) {
            event.setCancelled(true);
            event.getInventory().setItem(clickedSlot, cursorItem);
            if (currentItem != null && currentItem.getType() != Material.AIR && !this.inventoryGUIHelper.isFillerItem(currentItem)) {
                player.setItemOnCursor(currentItem);
            } else {
                player.setItemOnCursor(null);
            }
            player.updateInventory();
            return;
        }
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY || event.getAction() == InventoryAction.PICKUP_ALL || event.getAction() == InventoryAction.PICKUP_HALF || event.getAction() == InventoryAction.PICKUP_ONE || event.getAction() == InventoryAction.PICKUP_SOME) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.inventories, () -> {
                if (event.getInventory().getItem(clickedSlot) == null || event.getInventory().getItem(clickedSlot).getType() == Material.AIR) {
                    event.getInventory().setItem(clickedSlot, this.inventoryGUIHelper.createFillerItemForSlot(clickedSlot, true));
                }
            }, 1L);
        }
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.NORMAL)
    void onInventoryDrag(InventoryDragEvent event) {
        if (event.getInventory().getHolder() instanceof ReadOnlyInventoryHolder) {
            event.setCancelled(true);
        }
        if (!(event.getInventory().getHolder() instanceof ModifiableInventoryHolder)) {
            return;
        }
        ItemStack draggedItem = event.getCursor();
        if (draggedItem == null || draggedItem.getType() == Material.AIR) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            boolean isPaddingSlot;
            int slot = (Integer)iterator.next();
            boolean isSpecialSlot = slot >= 36 && slot <= 40;
            boolean bl = isPaddingSlot = slot >= 41 && slot <= 44;
            if (isPaddingSlot) {
                event.setCancelled(true);
                return;
            }
            if (!isSpecialSlot || this.inventoryGUIHelper.isValidItemForSlot(draggedItem, slot)) continue;
            event.setCancelled(true);
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.inventories, () -> {
            Iterator iterator = event.getRawSlots().iterator();
            while (iterator.hasNext()) {
                int slot = (Integer)iterator.next();
                if (slot < 36 || slot > 40 || event.getInventory().getItem(slot) != null && event.getInventory().getItem(slot).getType() != Material.AIR) continue;
                event.getInventory().setItem(slot, this.inventoryGUIHelper.createFillerItemForSlot(slot, true));
            }
        }, 1L);
    }

    @EventMethod
    @DefaultEventPriority(value=EventPriority.NORMAL)
    void onInventoryClose(InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof ModifiableInventoryHolder)) {
            return;
        }
        ModifiableInventoryHolder holder = (ModifiableInventoryHolder)inventoryHolder;
        OfflinePlayer targetPlayer = holder.getTargetPlayer();
        String worldName = holder.getWorldName();
        ProfileType profileType = holder.getProfileType();
        Inventory closedInventory = event.getInventory();
        ItemStack[] newContents = Arrays.copyOfRange(closedInventory.getContents(), 0, 36);
        ItemStack[] newArmor = new ItemStack[4];
        newArmor[3] = closedInventory.getItem(36);
        newArmor[2] = closedInventory.getItem(37);
        newArmor[1] = closedInventory.getItem(38);
        newArmor[0] = closedInventory.getItem(39);
        ItemStack newOffHand = closedInventory.getItem(40);
        for (int i = 0; i < newArmor.length; ++i) {
            if (newArmor[i] == null || !this.inventoryGUIHelper.isFillerItem(newArmor[i])) continue;
            newArmor[i] = null;
        }
        if (newOffHand != null && this.inventoryGUIHelper.isFillerItem(newOffHand)) {
            newOffHand = null;
        }
        this.inventoryDataProvider.savePlayerInventoryData(targetPlayer, worldName, profileType, newContents, newArmor, newOffHand).exceptionally(throwable -> {
            InvLogging.severe("Error during inventory save process for " + targetPlayer.getName() + ": " + throwable.getMessage(), new Object[0]);
            throwable.printStackTrace();
            return null;
        });
    }
}

