/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.bulkedit.playerprofile;

import java.util.Objects;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.flag.ParsedCommandFlags;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.external.vavr.collection.Array;
import org.mvplugins.multiverse.inventories.commands.bulkedit.BulkEditCommand;
import org.mvplugins.multiverse.inventories.commands.bulkedit.playerprofile.IncludeGroupsWorldsFlag;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditAction;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditCreator;
import org.mvplugins.multiverse.inventories.profile.bulkedit.PlayerProfilesPayload;
import org.mvplugins.multiverse.inventories.profile.key.ContainerKey;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;

@Service
public class CloneWorldGroupCommand
extends BulkEditCommand {
    private final CommandQueueManager commandQueueManager;
    private final IncludeGroupsWorldsFlag flags;

    @Inject
    CloneWorldGroupCommand(@NotNull BulkEditCreator bulkEditCreator, @NotNull CommandQueueManager commandQueueManager, @NotNull IncludeGroupsWorldsFlag flags) {
        super(bulkEditCreator);
        this.commandQueueManager = commandQueueManager;
        this.flags = flags;
    }

    @Subcommand(value="playerprofile clone-world-group")
    @CommandPermission(value="multiverse.inventories.bulkedit")
    @CommandCompletion(value="@mvinvplayernames @mvinvcontainerkey @mvinvcontainerkeys @mvinvprofiletypes:multiple @flags:groupName=mvinvincludegroupsworlds")
    @Syntax(value="<players> <from-group/world> <to-groups/worlds> [profile-type]")
    void onCommand(MVCommandIssuer issuer, @Syntax(value="<players>") GlobalProfileKey[] globalProfileKeys, @Syntax(value="<from-group/world>") ContainerKey fromContainerKey, @Syntax(value="<to-groups/worlds>") ContainerKey[] toContainerKeys, @Syntax(value="[profile-types]") ProfileType[] profileTypes, @Syntax(value="[--include-groups-worlds]") String[] flagArray) {
        if (Array.of((Object[])toContainerKeys).find(toKey -> Objects.equals(fromContainerKey, toKey)).peek(toKey -> issuer.sendError("Cannot copy profiles to the same " + String.valueOf((Object)toKey.getContainerType()) + ": " + toKey.getDataName(), new MessageReplacement[0])).isDefined()) {
            return;
        }
        ParsedCommandFlags parsedFlags = this.flags.parse(flagArray);
        BulkEditAction<?> bulkEditAction = this.bulkEditCreator.playerProfileCloneWorldGroup(fromContainerKey, new PlayerProfilesPayload(globalProfileKeys, toContainerKeys, profileTypes, parsedFlags.hasFlag(this.flags.includeGroupsWorlds)));
        this.outputActionSummary(issuer, bulkEditAction);
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer((MVCommandIssuer)issuer).prompt(Message.of((String)"Are you sure you want to clone profiles from %s %s to the selected groups/worlds?".formatted(new Object[]{fromContainerKey.getContainerType(), fromContainerKey.getDataName()}), (MessageReplacement[])new MessageReplacement[0])).action(() -> this.runBulkEditAction(issuer, bulkEditAction)));
    }
}

