/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands.bulkedit.globalprofile;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.config.handle.PropertyModifyAction;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;

@Service
final class ModifyCommand
extends InventoriesCommand {
    private final CommandQueueManager commandQueueManager;
    private final ProfileDataSource profileDataSource;

    @Inject
    ModifyCommand(CommandQueueManager commandQueueManager, ProfileDataSource profileDataSource) {
        this.commandQueueManager = commandQueueManager;
        this.profileDataSource = profileDataSource;
    }

    @Subcommand(value="globalprofile modify")
    @CommandPermission(value="multiverse.inventories.bulkedit")
    @CommandCompletion(value="load-on-login|last-world @empty @mvinvplayernames")
    @Syntax(value="<property> <value> <players>")
    void onCommand(MVCommandIssuer issuer, @Syntax(value="<property>") String property, @Syntax(value="<value>") String value, @Syntax(value="<players>") GlobalProfileKey[] profileKeys) {
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer((MVCommandIssuer)issuer).prompt(Message.of((String)"Are you sure you want to modify %s to %s for %d players?".formatted(property, value, profileKeys.length), (MessageReplacement[])new MessageReplacement[0])).action(() -> this.doModify(issuer, property, value, profileKeys)));
    }

    private void doModify(MVCommandIssuer issuer, String property, String value, GlobalProfileKey[] profileKeys) {
        AtomicInteger counter = new AtomicInteger(0);
        CompletableFuture[] futures = (CompletableFuture[])Arrays.stream(profileKeys).map(profileKey -> this.profileDataSource.modifyGlobalProfile((GlobalProfileKey)profileKey, globalProfile -> globalProfile.getStringPropertyHandle().modifyPropertyString(property, value, PropertyModifyAction.SET).onSuccess(ignore -> counter.incrementAndGet()).onFailure(throwable -> issuer.sendError("Failed to modify %s for %s. %s".formatted(property, profileKey, throwable.getMessage()), new MessageReplacement[0])))).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).thenRun(() -> issuer.sendMessage("Successfully modified %s to %s for %d players.".formatted(property, value, counter.get())));
    }
}

