/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.core.world.MultiverseWorld;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Flags;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.utils.InvLogging;
import org.mvplugins.multiverse.inventories.view.InventoryDataProvider;
import org.mvplugins.multiverse.inventories.view.InventoryGUIHelper;
import org.mvplugins.multiverse.inventories.view.PlayerInventoryData;
import org.mvplugins.multiverse.inventories.view.ReadOnlyInventoryHolder;

@Service
final class InventoryViewCommand
extends InventoriesCommand {
    private final InventoryDataProvider inventoryDataProvider;
    private final MultiverseInventories inventories;
    private final InventoryGUIHelper inventoryGUIHelper;

    @Inject
    InventoryViewCommand(@NotNull InventoryDataProvider inventoryDataProvider, @NotNull MultiverseInventories inventories, @NotNull InventoryGUIHelper inventoryGUIHelper) {
        this.inventories = inventories;
        this.inventoryDataProvider = inventoryDataProvider;
        this.inventoryGUIHelper = inventoryGUIHelper;
    }

    @Subcommand(value="view")
    @CommandPermission(value="multiverse.inventories.view")
    @CommandCompletion(value="@mvinvplayernames @mvworlds")
    @Syntax(value="<player> <world>")
    @Description(value="View a player's inventory in a specific world.")
    void onInventoryViewCommand(@NotNull MVCommandIssuer issuer, @Flags(value="resolve=issuerOnly") @NotNull Player player, @Syntax(value="<player>") @Description(value="Online or offline player") OfflinePlayer targetPlayer, @Syntax(value="<world>") @Description(value="The world the player's inventory is in") MultiverseWorld world) {
        String worldName = world.getName();
        issuer.sendInfo(String.valueOf(ChatColor.YELLOW) + "Loading inventory data for " + targetPlayer.getName() + "...", new MessageReplacement[0]);
        this.handleInventoryLoadAndDisplay(issuer, player, targetPlayer, worldName);
    }

    private void handleInventoryLoadAndDisplay(@NotNull MVCommandIssuer issuer, @NotNull Player player, @NotNull OfflinePlayer targetPlayer, @NotNull String worldName) {
        ((CompletableFuture)this.inventoryDataProvider.loadPlayerInventoryData(targetPlayer, worldName).thenAccept(playerInventoryData -> Bukkit.getScheduler().runTask((Plugin)this.inventories, () -> this.createAndOpenGUI(issuer, player, targetPlayer, worldName, (PlayerInventoryData)playerInventoryData)))).exceptionally(throwable -> {
            issuer.sendError(String.valueOf(ChatColor.RED) + "Failed to load inventory data: " + throwable.getMessage(), new MessageReplacement[0]);
            InvLogging.severe("Error loading inventory for " + targetPlayer.getName() + ": " + throwable.getMessage(), new Object[0]);
            throwable.printStackTrace();
            return null;
        });
    }

    private void createAndOpenGUI(@NotNull MVCommandIssuer issuer, @NotNull Player player, @NotNull OfflinePlayer targetPlayer, @NotNull String worldName, @NotNull PlayerInventoryData playerInventoryData) {
        String title = targetPlayer.getName() + " @ " + worldName;
        Inventory inv = Bukkit.createInventory((InventoryHolder)new ReadOnlyInventoryHolder(), (int)45, (String)title);
        this.inventoryGUIHelper.populateInventoryGUI(inv, playerInventoryData, false);
        player.openInventory(inv);
        issuer.sendInfo(String.valueOf(ChatColor.GREEN) + playerInventoryData.status.getFormattedMessage(targetPlayer.getName(), worldName) + ". Changes will save on close.", new MessageReplacement[0]);
    }
}

