/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.command.queue.CommandQueueManager;
import org.mvplugins.multiverse.core.command.queue.CommandQueuePayload;
import org.mvplugins.multiverse.core.locale.message.Message;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
final class DeleteGroupCommand
extends InventoriesCommand {
    private final CommandQueueManager commandQueueManager;
    private final WorldGroupManager worldGroupManager;

    @Inject
    DeleteGroupCommand(@NotNull CommandQueueManager commandQueueManager, @NotNull WorldGroupManager worldGroupManager) {
        this.commandQueueManager = commandQueueManager;
        this.worldGroupManager = worldGroupManager;
    }

    @Subcommand(value="delete-group")
    @CommandPermission(value="multiverse.inventories.deletegroup")
    @CommandCompletion(value="@worldGroups")
    @Syntax(value="<group>")
    @Description(value="Deletes a World Group.")
    void onDeleteGroupCommand(MVCommandIssuer issuer, @Syntax(value="<group>") @Description(value="Inventories group to delete.") WorldGroup group) {
        this.commandQueueManager.addToQueue(CommandQueuePayload.issuer((MVCommandIssuer)issuer).prompt((Message)Message.of((MessageKeyProvider)MVInvi18n.DELETEGROUP_CONFIRMPROMPT, (MessageReplacement[])new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName())})).action(() -> this.doDeleteGroup(issuer, group)));
        this.worldGroupManager.checkForConflicts().sendConflictIssue(issuer);
    }

    private void doDeleteGroup(MVCommandIssuer issuer, WorldGroup group) {
        this.worldGroupManager.removeGroup(group);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.DELETEGROUP_SUCCESS, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName())});
    }
}

