/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandManager;
import org.mvplugins.multiverse.core.config.CoreConfig;
import org.mvplugins.multiverse.core.destination.Destination;
import org.mvplugins.multiverse.core.destination.DestinationsProvider;
import org.mvplugins.multiverse.core.module.MultiverseModule;
import org.mvplugins.multiverse.core.utils.StringFormatter;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jakarta.inject.Provider;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.BstatsMetricsConfigurator;
import org.mvplugins.multiverse.inventories.InventoriesDupingPatch;
import org.mvplugins.multiverse.inventories.MultiverseInventoriesApi;
import org.mvplugins.multiverse.inventories.MultiverseInventoriesPluginBinder;
import org.mvplugins.multiverse.inventories.PlaceholderExpansionHook;
import org.mvplugins.multiverse.inventories.WorldGroupContextCalculator;
import org.mvplugins.multiverse.inventories.command.MVInvCommandCompletion;
import org.mvplugins.multiverse.inventories.command.MVInvCommandConditions;
import org.mvplugins.multiverse.inventories.command.MVInvCommandContexts;
import org.mvplugins.multiverse.inventories.command.MVInvCommandPermissions;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.destination.LastLocationDestination;
import org.mvplugins.multiverse.inventories.handleshare.SingleShareWriter;
import org.mvplugins.multiverse.inventories.handleshare.WriteOnlyShareHandler;
import org.mvplugins.multiverse.inventories.listeners.MVInvListener;
import org.mvplugins.multiverse.inventories.profile.PlayerNamesMapper;
import org.mvplugins.multiverse.inventories.profile.ProfileCacheManager;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.container.ProfileContainerStoreProvider;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.util.ItemStackConverter;
import org.mvplugins.multiverse.inventories.util.Perm;
import org.mvplugins.multiverse.inventories.utils.InvLogging;

@Service
public class MultiverseInventories
extends MultiverseModule {
    private static final double TARGET_CORE_API_VERSION = 5.3;
    @Inject
    private Provider<CoreConfig> coreConfig;
    @Inject
    private Provider<DestinationsProvider> destinationsProvider;
    @Inject
    private Provider<InventoriesConfig> inventoriesConfig;
    @Inject
    private Provider<WorldGroupManager> worldGroupManager;
    @Inject
    private Provider<PlayerNamesMapper> playerNamesMapperProvider;
    @Inject
    private Provider<ProfileDataSource> profileDataSource;
    @Inject
    private Provider<ProfileCacheManager> profileCacheManager;
    @Inject
    private Provider<ProfileContainerStoreProvider> profileContainerStoreProvider;
    @Inject
    private Provider<MVInvCommandCompletion> mvInvCommandCompletion;
    @Inject
    private Provider<MVInvCommandContexts> mvInvCommandContexts;
    @Inject
    private Provider<MVInvCommandConditions> mvInvCommandConditions;
    @Inject
    private Provider<MVInvCommandPermissions> mvInvCommandPermissions;
    @Inject
    private Provider<BstatsMetricsConfigurator> metricsConfiguratorProvider;
    private InventoriesDupingPatch dupingPatch;

    public void onLoad() {
        InvLogging.init((Plugin)this);
        this.getDataFolder().mkdirs();
    }

    public final void onEnable() {
        super.onEnable();
        this.initializeDependencyInjection(new MultiverseInventoriesPluginBinder(this));
        ProfileTypes.init(this);
        Sharables.init(this);
        Perm.register(this);
        ItemStackConverter.init(this);
        InvLogging.fine("ItemStackConverter is using byte serialization: " + ItemStackConverter.hasByteSerializeSupport(), new Object[0]);
        this.reloadConfig();
        ((InventoriesConfig)this.inventoriesConfig.get()).save().onFailure(e -> InvLogging.severe("Failed to save config file!", new Object[0]));
        this.registerDynamicListeners(MVInvListener.class);
        this.setUpLocales();
        this.registerCommands();
        this.registerDestinations();
        this.hookLuckPerms();
        this.loadPlaceholderApiIntegration();
        this.setupMetrics();
        this.dupingPatch = InventoriesDupingPatch.enableDupingPatch((Plugin)this);
        ((PlayerNamesMapper)this.playerNamesMapperProvider.get()).loadMap();
        MultiverseInventoriesApi.init(this);
        InvLogging.config("Version %s (API v%s) Enabled - By %s", this.getDescription().getVersion(), this.getVersionAsNumber(), StringFormatter.joinAnd((List)this.getDescription().getAuthors()));
    }

    public void onDisable() {
        super.onDisable();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (Player player : this.getServer().getOnlinePlayers()) {
            SingleShareWriter.of(this, player, Sharables.LAST_LOCATION).write(player.getLocation().clone());
            futures.add(new WriteOnlyShareHandler(this, player).handleSharing());
            if (!((InventoriesConfig)this.inventoriesConfig.get()).getApplyPlayerdataOnJoin()) continue;
            futures.add(((ProfileDataSource)this.profileDataSource.get()).modifyGlobalProfile(GlobalProfileKey.of((OfflinePlayer)player), profile -> profile.setLoadOnLogin(true)));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        MultiverseInventoriesApi.shutdown();
        this.dupingPatch.disable();
        this.shutdownDependencyInjection();
        InvLogging.shutdown();
    }

    private void registerCommands() {
        Try.run(() -> {
            this.mvInvCommandCompletion.get();
            this.mvInvCommandContexts.get();
            this.mvInvCommandConditions.get();
            this.mvInvCommandPermissions.get();
        }).onFailure(e -> InvLogging.warning("Failed to register command completers: %s", e.getMessage()));
        this.registerCommands(InventoriesCommand.class);
    }

    private void registerDestinations() {
        ((DestinationsProvider)this.destinationsProvider.get()).registerDestination((Destination)this.serviceLocator.getService(LastLocationDestination.class, new Annotation[0]));
    }

    private void hookLuckPerms() {
        Try.run(() -> Class.forName("net.luckperms.api.LuckPerms")).onFailure(e -> InvLogging.fine("Luckperms is not installed!", new Object[0])).andThenTry(() -> {
            InvLogging.fine("Found luckperms!", new Object[0]);
            this.serviceLocator.getService(WorldGroupContextCalculator.class, new Annotation[0]);
        });
    }

    private void loadPlaceholderApiIntegration() {
        if (!((InventoriesConfig)this.inventoriesConfig.get()).getRegisterPapiHook()) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            Try.run(() -> this.serviceLocator.getService(PlaceholderExpansionHook.class, new Annotation[0])).onFailure(e -> {
                InvLogging.severe("Failed to load PlaceholderAPI integration.", new Object[0]);
                e.printStackTrace();
            });
        }
    }

    private void setupMetrics() {
        Try.of((CheckedFunction0 & Serializable)() -> (BstatsMetricsConfigurator)this.metricsConfiguratorProvider.get()).onFailure(e -> {
            InvLogging.severe("Failed to setup metrics", new Object[0]);
            e.printStackTrace();
        });
    }

    public double getTargetCoreVersion() {
        return 5.3;
    }

    public void reloadConfig() {
        try {
            InvLogging.setDebugLevel(((CoreConfig)this.coreConfig.get()).getGlobalDebug());
            ((InventoriesConfig)this.inventoriesConfig.get()).load().onFailure(e -> {
                InvLogging.severe("Failed to load config file!", new Object[0]);
                InvLogging.severe(e.getMessage(), new Object[0]);
            });
            ((WorldGroupManager)this.worldGroupManager.get()).load().onFailure(e -> {
                InvLogging.severe("Failed to load world groups!", new Object[0]);
                InvLogging.severe(e.getMessage(), new Object[0]);
            });
            ((ProfileContainerStoreProvider)this.profileContainerStoreProvider.get()).clearCache();
            if (this.profileDataSource.get() != null) {
                ((ProfileCacheManager)this.profileCacheManager.get()).clearAllCache();
            }
            InvLogging.fine("Reloaded all config and groups!", new Object[0]);
        }
        catch (Exception e2) {
            InvLogging.severe("Encountered an error while loading the configuration file. Disabling...", new Object[0]);
            InvLogging.severe(e2.getMessage(), new Object[0]);
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            if (((InventoriesConfig)this.inventoriesConfig.get()).getFirstRun()) {
                InvLogging.info("First run!", new Object[0]);
                if (((WorldGroupManager)this.worldGroupManager.get()).getGroups().isEmpty()) {
                    ((WorldGroupManager)this.worldGroupManager.get()).createDefaultGroup();
                }
                ((InventoriesConfig)this.inventoriesConfig.get()).setFirstRun(false);
                ((InventoriesConfig)this.inventoriesConfig.get()).save();
            }
            ((WorldGroupManager)this.worldGroupManager.get()).checkForConflicts().sendConflictIssue(((MVCommandManager)this.commandManagerProvider.get()).getConsoleCommandIssuer());
        }, 1L);
    }
}

