/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.share;

import java.util.ArrayList;
import java.util.List;
import org.mvplugins.multiverse.inventories.share.DefaultSerializer;
import org.mvplugins.multiverse.inventories.share.DefaultSharable;
import org.mvplugins.multiverse.inventories.share.DefaultStringSerializer;
import org.mvplugins.multiverse.inventories.share.ProfileEntry;
import org.mvplugins.multiverse.inventories.share.SharableHandler;
import org.mvplugins.multiverse.inventories.share.SharableSerializer;

public interface Sharable<T> {
    public String[] getNames();

    public SharableHandler<T> getHandler();

    public SharableSerializer<T> getSerializer();

    public ProfileEntry getProfileEntry();

    public Class<T> getType();

    public boolean isOptional();

    public static class Builder<T> {
        private List<String> names = new ArrayList<String>();
        private ProfileEntry profileEntry = null;
        private SharableHandler<T> handler;
        private SharableSerializer<T> serializer = null;
        private boolean optional = false;
        private Class<T> type;

        public Builder(String name, Class<T> type, SharableHandler<T> handler) {
            this.names.add(name);
            this.handler = handler;
            this.type = type;
        }

        public Builder<T> optional() {
            this.optional = true;
            return this;
        }

        public Builder<T> altName(String name) {
            this.names.add(name);
            return this;
        }

        public Builder<T> stringSerializer(ProfileEntry entry) {
            this.serializer = new DefaultStringSerializer<T>(this.type);
            this.profileEntry = entry;
            return this;
        }

        public Builder<T> defaultSerializer(ProfileEntry entry) {
            this.serializer = new DefaultSerializer<T>(this.type);
            this.profileEntry = entry;
            return this;
        }

        public Builder<T> serializer(ProfileEntry entry, SharableSerializer<T> serializer) {
            this.serializer = serializer;
            this.profileEntry = entry;
            return this;
        }

        public Sharable<T> build() {
            DefaultSharable<T> sharable = new DefaultSharable<T>(this.names.toArray(new String[0]), this.type, this.handler, this.serializer, this.profileEntry, this.optional);
            ProfileEntry.register(sharable);
            return sharable;
        }
    }
}

