/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.bulkedit;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.mvplugins.multiverse.inventories.MultiverseInventories;
import org.mvplugins.multiverse.inventories.handleshare.ReadOnlyShareHandler;
import org.mvplugins.multiverse.inventories.profile.bulkedit.BulkEditAction;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;

final class GlobalProfileClearAction
extends BulkEditAction<GlobalProfileKey> {
    private final boolean clearPlayerProfile;

    GlobalProfileClearAction(MultiverseInventories inventories, GlobalProfileKey[] globalProfileKeys, boolean clearPlayerProfiles) {
        super(inventories, globalProfileKeys);
        this.clearPlayerProfile = clearPlayerProfiles;
    }

    @Override
    protected List<GlobalProfileKey> aggregateKeys() {
        return List.of(this.globalProfileKeys);
    }

    @Override
    protected CompletableFuture<Void> performAction(GlobalProfileKey key) {
        return this.profileDataSource.deleteGlobalProfile(key, this.clearPlayerProfile);
    }

    @Override
    protected boolean isOnlinePlayerAffected(GlobalProfileKey key, Player player) {
        return super.isOnlinePlayerAffected(key, player) && this.clearPlayerProfile;
    }

    @Override
    protected void updateOnlinePlayerNow(Player player) {
        new ReadOnlyShareHandler(this.inventories, player).handleSharing();
    }
}

