/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.dataimport.perworldinventory;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import me.ebonjaeger.perworldinventory.Group;
import me.ebonjaeger.perworldinventory.GroupManager;
import me.ebonjaeger.perworldinventory.api.PerWorldInventoryAPI;
import me.ebonjaeger.perworldinventory.configuration.PlayerSettings;
import me.ebonjaeger.perworldinventory.configuration.PluginSettings;
import me.ebonjaeger.perworldinventory.configuration.Settings;
import me.ebonjaeger.perworldinventory.data.FlatFile;
import me.ebonjaeger.perworldinventory.data.ProfileKey;
import me.ebonjaeger.perworldinventory.data.ProfileManager;
import me.ebonjaeger.perworldinventory.libs.json.JSONObject;
import me.ebonjaeger.perworldinventory.libs.json.parser.JSONParser;
import me.ebonjaeger.perworldinventory.serialization.PlayerSerializer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.core.utils.ReflectHelper;
import org.mvplugins.multiverse.core.world.WorldManager;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;
import org.mvplugins.multiverse.inventories.config.InventoriesConfig;
import org.mvplugins.multiverse.inventories.dataimport.DataImportException;
import org.mvplugins.multiverse.inventories.profile.GlobalProfile;
import org.mvplugins.multiverse.inventories.profile.ProfileDataSource;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileTypes;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.util.FutureNow;
import org.mvplugins.multiverse.inventories.utils.InvLogging;
import org.mvplugins.multiverse.inventories.utils.configuration.util.SerializationHelper;

final class PwiImportHelper {
    private final PerWorldInventoryAPI pwiAPI;
    private final InventoriesConfig inventoriesConfig;
    private final WorldManager worldManager;
    private final WorldGroupManager worldGroupManager;
    private final ProfileDataSource profileDataSource;
    private Settings pwiSettings;
    private GroupManager pwiGroupManager;
    private FlatFile pwiFlatFile;
    private File dataDirectory;
    private Method getFileMethod;
    private Method deserializeMethod;
    private List<OfflinePlayer> playerList;

    PwiImportHelper(@NotNull PerWorldInventoryAPI pwiAPI, @NotNull InventoriesConfig inventoriesConfig, @NotNull WorldManager worldManager, @NotNull WorldGroupManager worldGroupManager, @NotNull ProfileDataSource profileDataSource) {
        this.pwiAPI = pwiAPI;
        this.inventoriesConfig = inventoriesConfig;
        this.worldManager = worldManager;
        this.worldGroupManager = worldGroupManager;
        this.profileDataSource = profileDataSource;
    }

    void importData() throws DataImportException {
        this.pwiSetUp();
        this.transferConfigOptions();
        this.findPlayersWithData();
        for (Group group : this.getPWIGroups()) {
            this.createMVGroup(group);
            this.saveMVDataForGroup(group);
        }
    }

    private void pwiSetUp() {
        this.pwiSettings = (Settings)ReflectHelper.getFieldValue((Object)this.pwiAPI, (String)"settings", Settings.class);
        this.pwiGroupManager = (GroupManager)ReflectHelper.getFieldValue((Object)this.pwiAPI, (String)"groupManager", GroupManager.class);
        ProfileManager pwiProfileManager = (ProfileManager)ReflectHelper.getFieldValue((Object)this.pwiAPI, (String)"profileManager", ProfileManager.class);
        this.pwiFlatFile = (FlatFile)ReflectHelper.getFieldValue((Object)pwiProfileManager, (String)"dataSource", FlatFile.class);
        this.getFileMethod = ReflectHelper.getMethod((Object)this.pwiFlatFile, (String)"getFile", (Class[])new Class[]{ProfileKey.class});
        this.dataDirectory = (File)ReflectHelper.getFieldValue((Object)this.pwiFlatFile, (String)"dataDirectory", File.class);
        this.deserializeMethod = ReflectHelper.getMethod(SerializationHelper.class, (String)"deserialize", (Class[])new Class[]{Map.class, Boolean.TYPE});
    }

    private void transferConfigOptions() {
        this.inventoriesConfig.setEnableGamemodeShareHandling((Boolean)this.pwiSettings.getProperty(PluginSettings.SEPARATE_GM_INVENTORIES));
        this.inventoriesConfig.setApplyPlayerdataOnJoin((Boolean)this.pwiSettings.getProperty(PluginSettings.LOAD_DATA_ON_JOIN));
        this.inventoriesConfig.setDefaultUngroupedWorlds((Boolean)this.pwiSettings.getProperty(PluginSettings.SHARE_IF_UNCONFIGURED));
        this.inventoriesConfig.getActiveOptionalShares().setSharing(Sharables.ECONOMY, (boolean)((Boolean)this.pwiSettings.getProperty(PlayerSettings.USE_ECONOMY)));
        this.inventoriesConfig.save();
    }

    private void findPlayersWithData() throws DataImportException {
        if (this.dataDirectory == null) {
            throw new DataImportException("PerWorldInventory data directory not found!");
        }
        File[] playerFolders = this.dataDirectory.listFiles();
        if (playerFolders == null) {
            throw new DataImportException("Unable to traverse PerWorldInventory data directory!");
        }
        this.playerList = Arrays.stream(playerFolders).filter(File::isDirectory).map(file -> (UUID)Try.of((CheckedFunction0 & Serializable)() -> UUID.fromString(file.getName())).onFailure(throwable -> InvLogging.warning("Unable to convert %s to UUID: %s", file.getName(), throwable.getMessage())).getOrNull()).filter(Objects::nonNull).map(Bukkit::getOfflinePlayer).toList();
    }

    private Collection<Group> getPWIGroups() {
        HashSet<Group> groups = new HashSet<Group>(this.pwiGroupManager.getGroups().values());
        if (!this.inventoriesConfig.getDefaultUngroupedWorlds()) {
            this.worldManager.getWorlds().forEach(world -> groups.add(this.pwiGroupManager.getGroupFromWorld(world.getName())));
        }
        return groups;
    }

    private void createMVGroup(Group group) {
        InvLogging.finer("PerWorldInventory Group: %s", group);
        WorldGroup worldGroup = this.worldGroupManager.getGroup(group.getName());
        if (worldGroup == null) {
            worldGroup = this.worldGroupManager.newEmptyGroup(group.getName());
        }
        worldGroup.getShares().addAll(Sharables.allOf());
        worldGroup.addWorlds(group.getWorlds());
        if (group.getRespawnWorld() != null) {
            worldGroup.setSpawnWorld(group.getRespawnWorld());
        }
        this.worldGroupManager.updateGroup(worldGroup);
    }

    private void saveMVDataForGroup(Group group) throws DataImportException {
        for (OfflinePlayer offlinePlayer : this.playerList) {
            this.saveMVDataForPlayer(group, offlinePlayer);
        }
    }

    private void saveMVDataForPlayer(Group group, OfflinePlayer offlinePlayer) throws DataImportException {
        GlobalProfile globalProfile = FutureNow.get(this.profileDataSource.getGlobalProfile(GlobalProfileKey.of(offlinePlayer)));
        globalProfile.setLoadOnLogin((Boolean)this.pwiSettings.getProperty(PluginSettings.LOAD_DATA_ON_JOIN));
        this.profileDataSource.updateGlobalProfile(globalProfile);
        for (GameMode gameMode : GameMode.values()) {
            me.ebonjaeger.perworldinventory.data.PlayerProfile pwiPlayerData = this.getPWIPlayerData(offlinePlayer, group, gameMode);
            if (pwiPlayerData == null) continue;
            for (PlayerProfile mvProfile : this.getMVPlayerData(offlinePlayer, group, gameMode)) {
                this.transferToMVPlayerData(mvProfile, pwiPlayerData);
            }
        }
    }

    private List<PlayerProfile> getMVPlayerData(@NotNull OfflinePlayer offlinePlayer, @NotNull Group group, @NotNull GameMode gameMode) {
        ArrayList<PlayerProfile> profiles = new ArrayList<PlayerProfile>();
        profiles.add(FutureNow.get(this.profileDataSource.getPlayerProfile(org.mvplugins.multiverse.inventories.profile.key.ProfileKey.of(ContainerType.GROUP, group.getName(), ProfileTypes.forGameMode(gameMode), offlinePlayer.getUniqueId()))));
        for (String worldName : group.getWorlds()) {
            profiles.add(FutureNow.get(this.profileDataSource.getPlayerProfile(org.mvplugins.multiverse.inventories.profile.key.ProfileKey.of(ContainerType.WORLD, worldName, ProfileTypes.forGameMode(gameMode), offlinePlayer.getUniqueId()))));
        }
        return profiles;
    }

    @Nullable
    private me.ebonjaeger.perworldinventory.data.PlayerProfile getPWIPlayerData(@NotNull OfflinePlayer offlinePlayer, @NotNull Group group, @NotNull GameMode gameMode) throws DataImportException {
        me.ebonjaeger.perworldinventory.data.PlayerProfile pwiPlayerProfile;
        ProfileKey pwiKey = new ProfileKey(offlinePlayer.getUniqueId(), group, gameMode);
        File pwiPlayerDataFile = this.getPWIFile(pwiKey);
        if (!pwiPlayerDataFile.isFile()) {
            InvLogging.finer("No data for %s.", pwiKey.toString());
            return null;
        }
        try {
            JSONParser parser = new JSONParser(16);
            JSONObject jsonObject = (JSONObject)parser.parse((InputStream)new FileInputStream(pwiPlayerDataFile));
            pwiPlayerProfile = jsonObject.containsKey((Object)"==") ? (me.ebonjaeger.perworldinventory.data.PlayerProfile)ReflectHelper.invokeMethod(null, (Method)this.deserializeMethod, (Object[])new Object[]{jsonObject, true}) : PlayerSerializer.INSTANCE.deserialize(jsonObject, Objects.requireNonNull(offlinePlayer.getName()), 36, 27);
        }
        catch (Exception e) {
            InvLogging.severe("Unable to parse file into profile: " + pwiPlayerDataFile.getAbsolutePath(), new Object[0]);
            e.printStackTrace();
            return null;
        }
        if (pwiPlayerProfile == null) {
            InvLogging.warning("Empty serialization for %s.", pwiKey.toString());
            return null;
        }
        InvLogging.finer("Got pwiPlayerProfile for %s.", pwiKey.toString());
        return pwiPlayerProfile;
    }

    private File getPWIFile(ProfileKey pwiKey) throws DataImportException {
        return (File)ReflectHelper.invokeMethod((Object)this.pwiFlatFile, (Method)this.getFileMethod, (Object[])new Object[]{pwiKey});
    }

    private void transferToMVPlayerData(PlayerProfile mvPlayerProfile, me.ebonjaeger.perworldinventory.data.PlayerProfile pwiPlayerProfile) throws DataImportException {
        if (pwiPlayerProfile == null || mvPlayerProfile == null) {
            InvLogging.finer("Null profile(s). No data transferred for %s and %s.", mvPlayerProfile, pwiPlayerProfile);
            return;
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_INVENTORY)).booleanValue()) {
            mvPlayerProfile.set(Sharables.ARMOR, pwiPlayerProfile.getArmor());
            mvPlayerProfile.set(Sharables.INVENTORY, pwiPlayerProfile.getInventory());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.USE_ECONOMY)).booleanValue()) {
            mvPlayerProfile.set(Sharables.ECONOMY, pwiPlayerProfile.getBalance());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_ENDER_CHEST)).booleanValue()) {
            mvPlayerProfile.set(Sharables.ENDER_CHEST, pwiPlayerProfile.getEnderChest());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_EXHAUSTION)).booleanValue()) {
            mvPlayerProfile.set(Sharables.EXHAUSTION, Float.valueOf(pwiPlayerProfile.getExhaustion()));
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_EXP)).booleanValue()) {
            mvPlayerProfile.set(Sharables.EXPERIENCE, Float.valueOf(pwiPlayerProfile.getExperience()));
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_FALL_DISTANCE)).booleanValue()) {
            mvPlayerProfile.set(Sharables.FALL_DISTANCE, Float.valueOf(pwiPlayerProfile.getFallDistance()));
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_FIRE_TICKS)).booleanValue()) {
            mvPlayerProfile.set(Sharables.FIRE_TICKS, pwiPlayerProfile.getFireTicks());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_HUNGER)).booleanValue()) {
            mvPlayerProfile.set(Sharables.FOOD_LEVEL, pwiPlayerProfile.getFoodLevel());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_HUNGER)).booleanValue()) {
            mvPlayerProfile.set(Sharables.FOOD_LEVEL, pwiPlayerProfile.getFoodLevel());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_HEALTH)).booleanValue()) {
            mvPlayerProfile.set(Sharables.HEALTH, pwiPlayerProfile.getHealth());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_LEVEL)).booleanValue()) {
            mvPlayerProfile.set(Sharables.LEVEL, pwiPlayerProfile.getLevel());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_MAX_AIR)).booleanValue()) {
            mvPlayerProfile.set(Sharables.MAXIMUM_AIR, pwiPlayerProfile.getMaximumAir());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_POTION_EFFECTS)).booleanValue()) {
            mvPlayerProfile.set(Sharables.POTIONS, pwiPlayerProfile.getPotionEffects().toArray(new PotionEffect[0]));
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_REMAINING_AIR)).booleanValue()) {
            mvPlayerProfile.set(Sharables.REMAINING_AIR, pwiPlayerProfile.getRemainingAir());
        }
        if (((Boolean)this.pwiSettings.getProperty(PlayerSettings.LOAD_SATURATION)).booleanValue()) {
            mvPlayerProfile.set(Sharables.REMAINING_AIR, pwiPlayerProfile.getRemainingAir());
        }
        this.profileDataSource.updatePlayerProfile(mvPlayerProfile);
    }
}

