/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.commands;

import org.jvnet.hk2.annotations.Service;
import org.mvplugins.multiverse.core.command.MVCommandIssuer;
import org.mvplugins.multiverse.core.locale.message.MessageReplacement;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandCompletion;
import org.mvplugins.multiverse.external.acf.commands.annotation.CommandPermission;
import org.mvplugins.multiverse.external.acf.commands.annotation.Description;
import org.mvplugins.multiverse.external.acf.commands.annotation.Subcommand;
import org.mvplugins.multiverse.external.acf.commands.annotation.Syntax;
import org.mvplugins.multiverse.external.acf.locales.MessageKeyProvider;
import org.mvplugins.multiverse.external.jakarta.inject.Inject;
import org.mvplugins.multiverse.external.jetbrains.annotations.NotNull;
import org.mvplugins.multiverse.inventories.commands.InventoriesCommand;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroup;
import org.mvplugins.multiverse.inventories.profile.group.WorldGroupManager;
import org.mvplugins.multiverse.inventories.share.Sharables;
import org.mvplugins.multiverse.inventories.share.Shares;
import org.mvplugins.multiverse.inventories.util.MVInvi18n;

@Service
final class AddSharesCommand
extends InventoriesCommand {
    private final WorldGroupManager worldGroupManager;

    @Inject
    AddSharesCommand(@NotNull WorldGroupManager worldGroupManager) {
        this.worldGroupManager = worldGroupManager;
    }

    @Subcommand(value="add-shares")
    @CommandPermission(value="multiverse.inventories.addshares")
    @CommandCompletion(value="@worldGroups @shares")
    @Syntax(value="<group> <share[,extra]>")
    @Description(value="Add one or more shares to a group.")
    void onAddSharesCommand(MVCommandIssuer issuer, @Syntax(value="<group>") @Description(value="Group you want to add the shares to.") WorldGroup group, @Syntax(value="<share[,extra]>") @Description(value="One or more sharables to add.") Shares shares) {
        group.getShares().mergeShares(shares);
        this.worldGroupManager.updateGroup(group);
        Shares negativeshares = Sharables.allOf();
        negativeshares.setSharing(group.getShares(), false);
        issuer.sendInfo((MessageKeyProvider)MVInvi18n.SHARES_NOWSHARING, new MessageReplacement[]{MessageReplacement.replace((String)"{group}").with((Object)group.getName()), MessageReplacement.replace((String)"{shares}").with(group.getShares().toStringList()), MessageReplacement.replace((String)"{negativeshares}").with(negativeshares.toStringList())});
        this.worldGroupManager.checkForConflicts().sendConflictIssue(issuer);
    }
}

