/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.type.Bed;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.util.NumberConversions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.external.vavr.CheckedFunction0;
import org.mvplugins.multiverse.external.vavr.control.Try;

@SerializableAs(value="RespawnLocation")
@ApiStatus.AvailableSince(value="5.2")
public class RespawnLocation
extends Location {
    @Nullable
    private String worldName;
    @NotNull
    private RespawnLocationType respawnType = RespawnLocationType.UNKNOWN;

    public RespawnLocation(@Nullable String worldName, double x, double y, double z, @NotNull RespawnLocationType respawnType) {
        super(null, x, y, z);
        this.setWorldName(worldName);
        this.respawnType = respawnType;
    }

    public RespawnLocation(@Nullable String worldName, double x, double y, double z, float yaw, float pitch, @NotNull RespawnLocationType respawnType) {
        super(null, x, y, z, yaw, pitch);
        this.setWorldName(worldName);
        this.respawnType = respawnType;
    }

    public RespawnLocation(@Nullable World world, double x, double y, double z, @NotNull RespawnLocationType respawnType) {
        super(null, x, y, z);
        this.setWorldName(world == null ? null : world.getName());
        this.respawnType = respawnType;
    }

    public RespawnLocation(@Nullable World world, double x, double y, double z, float yaw, float pitch, @NotNull RespawnLocationType respawnType) {
        super(null, x, y, z, yaw, pitch);
        this.setWorldName(world == null ? null : world.getName());
        this.respawnType = respawnType;
    }

    public RespawnLocation(@NotNull Location location, @NotNull RespawnLocationType respawnType) {
        this(location.getWorld(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), respawnType);
    }

    public Location toBukkitLocation() {
        return new Location(this.getWorld(), this.getX(), this.getY(), this.getZ(), this.getYaw(), this.getPitch());
    }

    public void setWorldName(@Nullable String worldName) {
        this.worldName = worldName;
    }

    @Nullable
    public String getWorldName() {
        return this.worldName;
    }

    public void setWorld(@Nullable World world) {
        this.worldName = world == null ? null : world.getName();
    }

    @Nullable
    public World getWorld() {
        if (this.worldName == null) {
            return null;
        }
        return Bukkit.getWorld((String)this.worldName);
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.worldName != null) {
            data.put("world", this.worldName);
        }
        data.put("x", this.getX());
        data.put("y", this.getY());
        data.put("z", this.getZ());
        data.put("yaw", Float.valueOf(this.getYaw()));
        data.put("pitch", Float.valueOf(this.getPitch()));
        data.put("respawnType", this.respawnType.name());
        return data;
    }

    @NotNull
    public static Location deserialize(@NotNull Map<String, Object> args) {
        return new RespawnLocation(args.containsKey("world") ? args.get("world").toString() : null, NumberConversions.toDouble((Object)args.get("x")), NumberConversions.toDouble((Object)args.get("y")), NumberConversions.toDouble((Object)args.get("z")), NumberConversions.toFloat((Object)args.get("yaw")), NumberConversions.toFloat((Object)args.get("pitch")), args.containsKey("respawnType") ? (RespawnLocationType)((Object)Try.of((CheckedFunction0 & Serializable)() -> RespawnLocationType.valueOf(String.valueOf(args.get("respawnType")).toUpperCase(Locale.ROOT))).getOrElse((Object)RespawnLocationType.UNKNOWN)) : RespawnLocationType.UNKNOWN);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        String otherWorldName = (String)Try.of((CheckedFunction0 & Serializable)() -> {
            String string;
            if (other instanceof RespawnLocation) {
                RespawnLocation RespawnLocation2 = (RespawnLocation)other;
                string = RespawnLocation2.worldName;
            } else {
                string = other.getWorld().getName();
            }
            return string;
        }).getOrNull();
        if (!Objects.equals(this.worldName, otherWorldName)) {
            return false;
        }
        if (Double.doubleToLongBits(this.getX()) != Double.doubleToLongBits(other.getX())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getY()) != Double.doubleToLongBits(other.getY())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getZ()) != Double.doubleToLongBits(other.getZ())) {
            return false;
        }
        if (Float.floatToIntBits(this.getPitch()) != Float.floatToIntBits(other.getPitch())) {
            return false;
        }
        if (Float.floatToIntBits(this.getYaw()) != Float.floatToIntBits(other.getYaw())) {
            return false;
        }
        if (other instanceof RespawnLocation) {
            RespawnLocation otherRespawnLocation = (RespawnLocation)other;
            if (this.respawnType != otherRespawnLocation.respawnType) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + String.valueOf(this.worldName).hashCode();
        hash = 19 * hash + Long.hashCode(Double.doubleToLongBits(this.getX()));
        hash = 19 * hash + Long.hashCode(Double.doubleToLongBits(this.getY()));
        hash = 19 * hash + Long.hashCode(Double.doubleToLongBits(this.getZ()));
        hash = 19 * hash + Float.floatToIntBits(this.getPitch());
        hash = 19 * hash + Float.floatToIntBits(this.getYaw());
        hash = 19 * hash + this.respawnType.hashCode();
        return hash;
    }

    public String toString() {
        return "RespawnLocation{world=" + this.worldName + ",x=" + this.getX() + ",y=" + this.getY() + ",z=" + this.getZ() + ",pitch=" + this.getPitch() + ",yaw=" + this.getYaw() + ",respawnType=" + String.valueOf((Object)this.respawnType) + "}";
    }

    @ApiStatus.AvailableSince(value="5.2")
    public boolean isValidRespawnLocation() {
        World world = this.getWorld();
        if (world == null) {
            return false;
        }
        switch (this.respawnType.ordinal()) {
            case 0: {
                return world.getBlockAt((Location)this).getBlockData() instanceof Bed;
            }
            case 1: {
                return world.getBlockAt((Location)this).getType() == Material.RESPAWN_ANCHOR;
            }
        }
        return true;
    }

    @ApiStatus.AvailableSince(value="5.2")
    @NotNull
    public RespawnLocationType getRespawnType() {
        return this.respawnType;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public void setRespawnType(@NotNull RespawnLocationType respawnType) {
        this.respawnType = respawnType;
    }

    @ApiStatus.AvailableSince(value="5.2")
    public static enum RespawnLocationType {
        BED,
        ANCHOR,
        UNKNOWN;

    }
}

