/*
 * Decompiled with CFR 0.152.
 */
package org.mvplugins.multiverse.inventories.profile.key;

import com.google.common.base.Objects;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mvplugins.multiverse.inventories.profile.data.PlayerProfile;
import org.mvplugins.multiverse.inventories.profile.key.ContainerType;
import org.mvplugins.multiverse.inventories.profile.key.GlobalProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileKey;
import org.mvplugins.multiverse.inventories.profile.key.ProfileType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class ProfileFileKey
extends GlobalProfileKey {
    protected final ContainerType containerType;
    protected final String dataName;
    protected final int hashCode;

    public static ProfileFileKey fromPlayerProfile(PlayerProfile profile) {
        return ProfileFileKey.of(profile.getContainerType(), profile.getContainerName(), profile.getPlayerUUID(), profile.getPlayerName());
    }

    public static ProfileFileKey of(ContainerType containerType, String dataName, GlobalProfileKey globalProfileKey) {
        return ProfileFileKey.of(containerType, dataName, globalProfileKey.getPlayerUUID(), globalProfileKey.getPlayerName());
    }

    public static ProfileFileKey of(ContainerType containerType, String dataName, OfflinePlayer offlinePlayer) {
        return ProfileFileKey.of(containerType, dataName, offlinePlayer.getUniqueId(), offlinePlayer.getName());
    }

    public static ProfileFileKey of(ContainerType containerType, String dataName, UUID playerUUID, String playerName) {
        return new ProfileFileKey(containerType, dataName, playerUUID, playerName);
    }

    private ProfileFileKey(ContainerType containerType, String dataName, UUID playerUUID, String playerName) {
        this(containerType, dataName, playerUUID, playerName, Objects.hashCode((Object[])new Object[]{containerType, dataName, playerUUID, playerName}));
    }

    protected ProfileFileKey(ContainerType containerType, String dataName, UUID playerUUID, String playerName, int hashCode) {
        super(playerUUID, playerName);
        this.containerType = containerType;
        this.dataName = dataName;
        this.hashCode = hashCode;
    }

    public ProfileKey forProfileType(@Nullable ProfileType profileType) {
        return ProfileKey.of(this.containerType, this.dataName, profileType, this.playerUUID, this.playerName);
    }

    public ProfileFileKey forContainerType(@NotNull ContainerType containerType) {
        return new ProfileFileKey(containerType, this.dataName, this.playerUUID, this.playerName);
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public String getDataName() {
        return this.dataName;
    }

    public boolean isSameFile(ProfileFileKey other) {
        return Objects.equal((Object)((Object)this.getContainerType()), (Object)((Object)other.getContainerType())) && Objects.equal((Object)this.getDataName(), (Object)other.getDataName()) && Objects.equal((Object)this.getPlayerUUID(), (Object)other.getPlayerUUID());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileKey)) {
            return false;
        }
        ProfileKey that = (ProfileKey)o;
        return this.getContainerType() == that.getContainerType() && Objects.equal((Object)this.getDataName(), (Object)that.getDataName()) && Objects.equal((Object)this.getPlayerUUID(), (Object)that.getPlayerUUID());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public String toString() {
        return "ProfileFileKey{containerType=" + String.valueOf((Object)this.containerType) + ", dataName='" + this.dataName + "', playerName='" + this.playerName + "', playerUUID=" + String.valueOf(this.playerUUID) + "}";
    }
}

